package com.biz.crm.cps.business.policy.scan.cycle.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 扫码分利表达式
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeExpression", description = "扫码分利表达式")
@TableName("cycle_scan_code_expression")
public class ScanCodeExpression extends BaseIdEntity {

  private static final long serialVersionUID = -1795430216130114706L;

  /**
   * 扫码事件
   *  @JoinColumn(name = "event_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 扫码事件 '")
   *  @ManyToOne(fetch = FetchType.LAZY)
   */
  @ApiModelProperty("扫码事件")
  @TableField(exist = false)
  private ScanCodeEvent scanCodeEvent;

  /**
   * 主表：扫码事件的ID
   *   @Column(name = "event_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 主表：扫码事件的ID '")
   */
  @ApiModelProperty("主表：扫码事件的ID")
  @TableField(value = "event_id")
  private String eventId;

  /**
   * 上级id（本表中非传递奖励的id，即该字段有值就代表该条信息是传递奖励）
   *   @Column(name = "expression_id" , nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 上级id（本表中非传递奖励的id，即该字段有值就代表该条信息是传递奖励） '")
   */
  @ApiModelProperty("上级id（本表中非传递奖励的id，即该字段有值就代表该条信息是传递奖励）")
  @TableField(value = "expression_id")
  private String expressionId;

  /**
   * 扫码行为主体(分利参与者 标记）
   * @Column(name = "participator_flag", nullable = true, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 扫码行为主体(分利参与者 标记） '")
   */
  @ApiModelProperty("扫码行为主体(分利参与者 标记）")
  @TableField(value = "participator_flag")
  private String participatorFlag;

  /**
   * 扫码行为主体(分利参与者 中文名）
   * @Column(name = "participator_name", nullable = true, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 扫码行为主体(分利参与者 中文名） '")
   */
  @ApiModelProperty("扫码行为主体(分利参与者 中文名）")
  @TableField(value = "participator_name")
  private String participatorName;

  /**
   * 奖励方式标志
   * @Column(name = "reward_method_flag", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 奖励方式标志 '")
   */
  @ApiModelProperty("奖励方式标志")
  @TableField(value = "reward_method_flag")
  private String rewardMethodFlag;

  /**
   * 奖励方式名称
   * @Column(name = "reward_method_name", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 奖励方式名称 '")
   */
  @ApiModelProperty("奖励方式名称")
  @TableField(value = "reward_method_name")
  private String rewardMethodName;

  /**
   * 奖励条件标志
   * @Column(name = "award_condition_flag", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 奖励条件标志 '")
   */
  @ApiModelProperty("奖励条件标志")
  @TableField(value = "award_condition_flag")
  private String awardConditionFlag;

  /**
   * 奖励条件名称
   * @Column(name = "award_condition_name", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 奖励条件名称 '")
   */
  @ApiModelProperty("奖励条件名称")
  @TableField(value = "award_condition_name")
  private String awardConditionName;

  /**
   * 奖励数据
   * @Column(name = "reward_data", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 奖励数据 '")
   */
  @ApiModelProperty("奖励数据")
  @TableField(value = "reward_data")
  private String rewardData;

  /**
   * 奖励周期 (current-实时、month-月、season-季度、halfYear-半年、year-年)
   * @Column(name = "reward_cycle", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 奖励周期 '")
   */
  @ApiModelProperty("奖励周期")
  @TableField(value = "reward_cycle")
  private String rewardCycle;

  /**
   * 扫码分利表达式
   * @OneToMany(fetch = FetchType.LAZY,mappedBy = "scanCodeExpression")
   */
  @ApiModelProperty("扫码分利表达式")
  @TableField(exist = false)
  private Set<ScanCodeExpression> scanCodeExpressions;

}
