package com.biz.crm.cps.business.policy.scan.cycle.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

/**
 * 扫码政策的奖励任务
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeTask", description = "扫码政策的奖励任务")
@TableName("cycle_scan_code_task")
public class ScanCodeTask extends TenantEntity {

  private static final long serialVersionUID = -6565648247353508111L;

  /**
   * 得到这份奖励的参与者(分利参与者 标记）
   *
   */
  @ApiModelProperty("得到这份奖励的参与者(分利参与者 标记）")
  @TableField(value = "participator_flag")
  @Column(name = "participator_flag" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 得到这份奖励的参与者(分利参与者 标记） '")
  private String participatorFlag;

  /**传递时不设置此参数，此参数由实际扫码者查询获取
   * 得到这份奖励的参与者(分利参与者 中文名）
   */
  @ApiModelProperty("得到这份奖励的参与者(分利参与者 中文名）")
  @TableField(value = "participator_name")
  @Column(name = "participator_name" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '得到这份奖励的参与者(分利参与者 中文名） '")
  private String participatorName;

  /**
   * 奖励方式标志（费用，红包，等等）
   */
  @ApiModelProperty("奖励方式标志（费用，红包，等等）")
  @TableField(value = "reward_method_flag")
  @Column(name = "reward_method_flag" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '奖励方式标志（费用，红包，等等）'")
  private String rewardMethodFlag;

  /**
   * 奖励方式名称（费用，红包，等等）
   */
  @ApiModelProperty("奖励方式名称（费用，红包，等等）")
  @TableField(value = "reward_method_name")
  @Column(name = "reward_method_name" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '奖励方式名称（费用，红包，等等）'")
  private String rewardMethodName;

  /**
   * 奖励条件标志(固定额度，定额随机)
   */
  @ApiModelProperty("奖励条件标志(固定额度，定额随机)")
  @TableField(value = "award_condition_flag")
  @Column(name = "award_condition_flag" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '奖励条件标志(固定额度，定额随机)'")
  private String awardConditionFlag;

  /**
   * 奖励条件名称(固定额度，定额随机)
   */
  @ApiModelProperty("奖励条件名称(固定额度，定额随机)")
  @TableField(value = "award_condition_name")
  @Column(name = "award_condition_name" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '奖励条件名称(固定额度，定额随机)'")
  private String awardConditionName;

  /**
   * 奖励数据
   * 当为 固定随机时
   * <pre>
   *   [
   *   {
   *     "cash": 10, //金额
   *     "percent": 10 //占用比例
   *   },
   *   {
   *     "cash": 20,
   *     "percent": 20
   *   },
   *   {
   *     "cash": 30,
   *     "percent": 70
   *   }
   * ]
   * </pre>
   */
  @ApiModelProperty("奖励数据")
  @TableField(value = "reward_data")
  @Column(name = "reward_data" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '奖励数据'")
  private String rewardData;

  /**
   * 参与者编码（实际扫码者）
   */
  @ApiModelProperty("参与者编码（实际扫码者）")
  @TableField(value = "actual_participator_code")
  @Column(name = "actual_participator_code" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '参与者编码（实际扫码者）'")
  private String actualParticipatorCode;

  /**
   * ParticipatorTypeEnum
   * 参与者标记（实际扫码者） 1-经销商，2-终端，3-消费者
   */
  @ApiModelProperty("参与者标记（实际扫码者）")
  @TableField(value = "actual_participator_flag")
  @Column(name = "actual_participator_flag" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '参与者标记（实际扫码者） 1-经销商，2-终端，3-消费者 '")
  private String actualParticipatorFlag;

  /**
   * 触发动作所属政策
   */
  @ApiModelProperty("政策名称")
  @TableField(value = "policy_name")
  @Column(name = "policy_name" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '政策名称 '")
  private String policyName;

  /**
   * 触发动作
   */
  @ApiModelProperty("触发动作")
  @TableField(value = "trigger_action")
  @Column(name = "trigger_action" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '触发动作'")
  private String triggerAction;

  /**
   * 触发对象
   */
  @ApiModelProperty("触发对象")
  @TableField(value = "trigger_object")
  @Column(name = "trigger_object" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '触发对象'")
  private String triggerObject;

  /**
   * 模版编码
   */
  @ApiModelProperty("模版编码")
  @TableField(value = "template_code")
  @Column(name = "template_code" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '模版编码'")
  private String templateCode;
  /**
   * 机构编码
   */
  @ApiModelProperty("机构编码")
  @TableField(value = "org_code")
  @Column(name = "org_code" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '机构编码'")
  private String orgCode;

  /**
   * 机构名称
   */
  @ApiModelProperty("机构名称")
  @TableField(value = "org_name")
  @Column(name = "org_name" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '机构名称'")
  private String orgName;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  @TableField(value = "phone")
  @Column(name = "phone" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '手机号'")
  private String phone;

  /**
   * 参与者所属渠道
   */
  @ApiModelProperty("参与者所属渠道")
  @TableField(value = "channel")
  @Column(name = "channel" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '参与者所属渠道'")
  private String channel;

  /**
   * 扫码记录编码
   */
  @ApiModelProperty("扫码记录编码")
  @TableField(value = "record_code")
  @Column(name = "record_code" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '扫码记录编码'")
  private String recordCode;

  /**
   * 区分是得到这份奖励的参与者 还是实际扫码者 为了保存插入字段取值用。
   */
  @ApiModelProperty("区分标识")
  @TableField(value = "distinguish_flag")
  @Column(name = "distinguish_flag" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '区分是得到这份奖励的参与者 还是实际扫码者 为了保存插入字段取值用。'")
  private String distinguishFlag;

  /**
   * 赠品编码
   */
  @ApiModelProperty("赠品编码")
  @TableField(value = "gift_code")
  @Column(name = "gift_code" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 赠品编码'")
  private String giftCode;

  /**
   * 奖励任务状态, 1-未结算，2-已结算
   */
  @ApiModelProperty("奖励任务状态")
  @TableField(value = "reward_status")
  @Column(name = "reward_status" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 奖励任务状态'")
  private String rewardStatus;

  /**
   * 奖励周期 (current-实时、month-月、season-季度、halfYear-半年、year-年)
   */
  @ApiModelProperty("奖励周期 (current-实时、month-月、season-季度、halfYear-半年、year-年)")
  @TableField(value = "reward_cycle")
  @Column(name = "reward_cycle" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 奖励周期 (current-实时、month-月、season-季度、halfYear-半年、year-年)'")
  private String rewardCycle;

  /**
   * 任务时间
   */
  @ApiModelProperty("任务时间")
  @TableField(value = "task_time")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @Column(name = "task_time" , nullable = false, columnDefinition = "datetime COMMENT ' 任务时间'")
  private Date taskTime;

  /**
   * 返利类型（正向，反向）
   */
  @ApiModelProperty("返利类型（正向，反向）")
  @TableField(value = "rebate_type")
  @Column(name = "rebate_type" , nullable = false, columnDefinition = "VARCHAR(32) COMMENT ' 返利类型（正向，反向）'")
  private String rebateType;

  /**
   * 传递奖励任务
   */
  @ApiModelProperty("传递奖励任务")
  @TableField(exist = false)
  List<ScanCodeTask> scanCodeTasks;

}
