package com.biz.crm.cps.business.policy.scan.cycle.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeEvent;
import com.biz.crm.cps.business.policy.scan.cycle.local.mapper.ScanCodeEventMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 扫码事件的数据库操作类
 * @author hefan
 */
@Component
public class ScanCodeEventRepository extends ServiceImpl<ScanCodeEventMapper, ScanCodeEvent> {

  /**
   * 根据配置行id删除关联信息
   * @param configurationId
   */
  public void deleteByConfigurationId(String configurationId) {
    this.lambdaUpdate().eq(ScanCodeEvent::getConfigurationId, configurationId).remove();
  }

  /**
   * 根据配置行id查询扫码事件信息
   * @param configurationId
   * @return
   */
  public List<ScanCodeEvent> findByConfigurationId(String configurationId) {
    return this.lambdaQuery().eq(ScanCodeEvent::getConfigurationId, configurationId).list();
  }
}
