package com.biz.crm.cps.business.policy.scan.cycle.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeRange;
import com.biz.crm.cps.business.policy.scan.cycle.local.mapper.ScanCodeRangeMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 扫码范围的数据库操作类
 * @author hefan
 */
@Component
public class ScanCodeRangeRepository extends ServiceImpl<ScanCodeRangeMapper, ScanCodeRange> {

  /**
   * 根据配置行id删除产品信息
   * @param configurationId
   */
  public void deleteByConfigurationId(String configurationId) {
    this.lambdaUpdate().eq(ScanCodeRange::getConfigurationId, configurationId).remove();
  }

  /**
   * 根据配置行id查询信息
   * @param configurationId
   * @return
   */
  public List<ScanCodeRange> findByConfigurationId(String configurationId) {
    List<ScanCodeRange> list = this.lambdaQuery().eq(ScanCodeRange::getConfigurationId, configurationId).list();
    return list;
  }
}
