package com.biz.crm.cps.business.policy.scan.cycle.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeTask;
import com.biz.crm.cps.business.policy.scan.cycle.local.mapper.ScanCodeTaskMapper;
import com.biz.crm.cps.business.policy.scan.sdk.dto.CycleScanCodeTaskDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 扫码任务相关的数据库操作
 * @author songjingen
 */
@Component
public class ScanCodeTaskRepository extends ServiceImpl<ScanCodeTaskMapper, ScanCodeTask> {

  @Autowired
  private ScanCodeTaskMapper scanCodeTaskMapper;

  /**
   * 通过条件查询数据
   * @param cycleScanCodeTaskDto
   * @return
   */
  public List<ScanCodeTask> findByConditions(CycleScanCodeTaskDto cycleScanCodeTaskDto) {
    return this.scanCodeTaskMapper.findByConditions(cycleScanCodeTaskDto);
  }
}
