package com.biz.crm.cps.business.policy.scan.cycle.local.service.internal;

import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeTask;
import com.biz.crm.cps.business.policy.scan.cycle.local.repository.ScanCodeTaskRepository;
import com.biz.crm.cps.business.policy.scan.cycle.local.service.ScanCodeTaskService;
import com.biz.crm.cps.business.policy.scan.sdk.common.enums.RewardTaskStatusEnum;
import com.biz.crm.cps.business.policy.scan.sdk.dto.CycleScanCodeTaskDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 扫码周期任务实现类
 * @author songjingen
 */
@Service
public class ScanCodeTaskServiceImpl implements ScanCodeTaskService {

  @Autowired
  private ScanCodeTaskRepository scanCodeTaskRepository;
  /**
   * 新增
   * @param scanCodeTasks
   */
  @Transactional
  @Override
  public void createBatch(List<ScanCodeTask> scanCodeTasks) {
    if (CollectionUtils.isEmpty(scanCodeTasks)) {
      return;
    }
    Date date = new Date();
    for (ScanCodeTask scanCodeTask : scanCodeTasks) {
      scanCodeTask.setTenantCode(TenantUtils.getTenantCode());
      scanCodeTask.setRewardStatus(RewardTaskStatusEnum.STATUS_WAIT.getCode());
      scanCodeTask.setTaskTime(date);
      this.createValidation(scanCodeTask);
    }
   this.scanCodeTaskRepository.saveBatch(scanCodeTasks);
  }

  /**
   * 通过条件查询数据
   * @param cycleScanCodeTaskDto
   * @return
   */
  @Override
  public List<ScanCodeTask> findByConditions(CycleScanCodeTaskDto cycleScanCodeTaskDto) {
    if (cycleScanCodeTaskDto == null) {
      cycleScanCodeTaskDto = new CycleScanCodeTaskDto();
    }
    return this.scanCodeTaskRepository.findByConditions(cycleScanCodeTaskDto);
  }

  /**
   * 批量修改
   * @param scanCodeTasks
   */
  @Transactional
  @Override
  public void updateBatch(List<ScanCodeTask> scanCodeTasks) {
    if (CollectionUtils.isEmpty(scanCodeTasks)) {
      return;
    }
    for (ScanCodeTask scanCodeTask : scanCodeTasks) {
      this.updateValidation(scanCodeTask);
    }
    this.scanCodeTaskRepository.updateBatchById(scanCodeTasks);
  }


  private void createValidation(ScanCodeTask scanCodeTask) {
    Validate.notNull(scanCodeTask, "进行新增操作时，新增对象不能为空！");
    scanCodeTask.setId(null);
    Validate.notNull(scanCodeTask.getTriggerAction(), "进行新增操作时，触发动作不能为空！");
    Validate.notNull(scanCodeTask.getTriggerObject(), "进行新增操作时，触发对象不能为空！");
    Validate.notNull(scanCodeTask.getActualParticipatorCode(), "进行新增操作时，参与者编码（实际扫码者）不能为空！");
    Validate.notNull(scanCodeTask.getActualParticipatorFlag(), "进行新增操作时，参与者标记（实际扫码者）不能为空！");
    Validate.notNull(scanCodeTask.getAwardConditionFlag(), "进行新增操作时，奖励条件标志(固定额度，定额随机)不能为空！");
    Validate.notNull(scanCodeTask.getAwardConditionName(), "进行新增操作时，出发对象不能为空！");
    Validate.notNull(scanCodeTask.getRecordCode(), "进行新增操作时，扫码记录编码不能为空！");
    Validate.notNull(scanCodeTask.getRewardCycle(), "进行新增操作时，奖励周期不能为空！");
    Validate.notNull(scanCodeTask.getRewardData(), "进行新增操作时，奖励数据不能为空！");
    Validate.notNull(scanCodeTask.getTemplateCode(), "进行新增操作时，模板编码不能为空！");
    Validate.notNull(scanCodeTask.getRewardMethodFlag(), "进行新增操作时，奖励方式标志不能为空！");
    Validate.notNull(scanCodeTask.getRewardMethodName(), "进行新增操作时，奖励方式名称不能为空！");
  }

  private void updateValidation(ScanCodeTask scanCodeTask) {
    Validate.notNull(scanCodeTask, "进行修改操作时，新增对象不能为空！");
    Validate.notNull(scanCodeTask.getId(), "进行修改操作时，id不能为空！");
    Validate.notNull(scanCodeTask.getTriggerAction(), "进行修改操作时，触发动作不能为空！");
    Validate.notNull(scanCodeTask.getTriggerObject(), "进行修改操作时，触发对象不能为空！");
    Validate.notNull(scanCodeTask.getActualParticipatorCode(), "进行修改操作时，参与者编码（实际扫码者）不能为空！");
    Validate.notNull(scanCodeTask.getActualParticipatorFlag(), "进行修改操作时，参与者标记（实际扫码者）不能为空！");
    Validate.notNull(scanCodeTask.getAwardConditionFlag(), "进行修改操作时，奖励条件标志(固定额度，定额随机)不能为空！");
    Validate.notNull(scanCodeTask.getAwardConditionName(), "进行修改操作时，出发对象不能为空！");
    Validate.notNull(scanCodeTask.getRecordCode(), "进行修改操作时，扫码记录编码不能为空！");
    Validate.notNull(scanCodeTask.getRewardCycle(), "进行修改操作时，奖励周期不能为空！");
    Validate.notNull(scanCodeTask.getRewardData(), "进行修改操作时，奖励数据不能为空！");
    Validate.notNull(scanCodeTask.getTemplateCode(), "进行修改操作时，模板编码不能为空！");
    Validate.notNull(scanCodeTask.getRewardMethodFlag(), "进行修改操作时，奖励方式标志不能为空！");
    Validate.notNull(scanCodeTask.getRewardMethodName(), "进行修改操作时，奖励方式名称不能为空！");
  }
}
