package com.biz.crm.cps.business.policy.scan.cycle.local.service.observer;

import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeConfiguration;
import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeRange;
import com.biz.crm.cps.business.policy.scan.cycle.local.service.ScanCodeConfigurationService;
import com.biz.crm.cps.business.product.sdk.common.enums.MaterialDimensionEnum;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeVerifyEventListener;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component
public class ScanCodeEventListenerImpl implements ScanCodeVerifyEventListener {

  @Autowired
  private AgreementVoService agreementVoService;

  @Autowired
  private ScanCodeConfigurationService scanCodeConfigurationService;

  @Autowired
  private MaterialVoService materialVoService;

  /**
   * step 1 获取当前参与者已签署的协议列表
   * step 2 根据协议列表获取扫码模板配置
   * step 3 循环扫码模板配置，校验物料编码
   *
   * @param dto 扫码请求参数
   */
  @Override
  public void checkBarcode(ScanCodeExceptionStrategyDto dto) {
    //step 1 ========
    LoginUserAgreementDto agreementDto = new LoginUserAgreementDto();
    if (dto.getParticipatorType().equals(ParticipatorTypeEnum.DEALER.getKey())) {
      agreementDto.setCustomerCode(dto.getScanParticipatorCode());
    } else {
      agreementDto.setTerminalCode(dto.getScanParticipatorCode());
    }
    List<AgreementVo> agreementVos = this.agreementVoService.findByConditions(agreementDto);
    Validate.isTrue(!CollectionUtils.isEmpty(agreementVos), "扫码人未签署任何协议");
    //step 2 ========
    Set<String> agreementCodes = agreementVos.stream().map(AgreementVo::getTemplateCode).collect(Collectors.toSet());
    List<ScanCodeConfiguration> codeConfigurations = this.scanCodeConfigurationService.findDetailsByTemplateCodes(agreementCodes);
    Validate.isTrue(!CollectionUtils.isEmpty(codeConfigurations), "扫码人签署的协议已经失效");
    //step 3 ========
    boolean checkSuccess = false;
    for (ScanCodeConfiguration config : codeConfigurations) {
      if (MaterialDimensionEnum.ALL.getKey().equals(config.getDimensionFlag())) {
        checkSuccess = true;
        break;
      }
      List<String> dimensionCodes = config.getScanCodeRanges().stream().map(ScanCodeRange::getSpecialCode).collect(Collectors.toList());
      List<String> materialCodes = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(dimensionCodes, config.getDimensionFlag());
      if (!CollectionUtils.isEmpty(materialCodes) && materialCodes.contains(dto.getProductCode())) {
        checkSuccess = true;
        break;
      }
    }
    Validate.isTrue(checkSuccess,"本次扫码物料未存在已签署协议中");
  }
}
