package com.biz.crm.cps.business.policy.scan.cycle.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyMountRegister;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyPojoObserver;
import com.biz.crm.cps.business.policy.scan.sdk.dto.ScanCodeConfigurationDto;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 扫码政策，用来处理协议模板与政策之间的对象转换
 * @author hefan
 */
@Component("ScanCodePolicyPojoObserverImpl")
public class ScanCodePolicyPojoObserverImpl implements AgreementPolicyPojoObserver {

  @Autowired
  @Qualifier("ScanCodePolicyMountRegisterImpl")
  private AgreementPolicyMountRegister agreementPolicyMountRegister;

  @Override
  public AgreementPolicyDto deserialize(JSONObject jsonObject) {
    /**
     * 把字符串转json对象
     * 获取跟扫码政策相关的信息
     * 将信息拷贝到对象中
     */
    if (Objects.isNull(jsonObject)) {
      return null;
    }
    ScanCodeConfigurationDto scanCodeConfigurationDto = JsonUtils.json2Obj(jsonObject.toJSONString(), ScanCodeConfigurationDto.class);
    return scanCodeConfigurationDto;
  }

  @Override
  public JSONObject serialize(AgreementPolicyDto agreementPolicyDto) {
    // TODO
    return null;
  }
}
