/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.scan.cycle.local.controller;

import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeConfiguration;
import com.biz.crm.cps.business.policy.scan.cycle.local.service.ScanCodeConfigurationService;
import com.biz.crm.cps.business.policy.scan.cycle.local.service.dynamictask.ScanCodeDynamicTask;
import com.biz.crm.cps.business.policy.scan.sdk.dto.ScanCodeConfigurationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5206\u5229\u653f\u7b56---\u626b\u7801\u653f\u7b56"})
@RestController
@RequestMapping(value={"/v1/policy/scan"})
public class ScanCodeConfigurationController {
    private static final Logger log = LoggerFactory.getLogger(ScanCodeConfigurationController.class);
    @Resource
    private ScanCodeConfigurationService scanCodeConfigurationService;
    @Autowired
    private ScanCodeDynamicTask scanCodeDynamicTask;

    @ApiOperation(value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efaterminal\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9terminal\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u57fa\u4e8e\uff08Terminal\uff09\u6a21\u578b\u7684\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684terminalJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PostMapping(value={""})
    public Result<ScanCodeConfiguration> create(@RequestBody @ApiParam(name="scanCodeConfigurationDto", value="") ScanCodeConfigurationDto scanCodeConfigurationDto) {
        try {
            ScanCodeConfiguration current = this.scanCodeConfigurationService.create((AgreementPolicyDto)scanCodeConfigurationDto);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u6267\u884c\u5956\u52b1\u4efb\u52a1\uff0c\u8be5\u63a5\u53e3\u4e3a\u5f00\u53d1\u8c03\u8bd5\u529f\u80fd\u65f6\u4f7f\u7528\u7684\u3002\u524d\u7aef\u4e0d\u53ef\u8c03\u7528")
    @PostMapping(value={"findByCycle"})
    public Result<?> findByCycle(@ApiParam(name="cycle", value="") String cycle) {
        try {
            if ("month".equals(cycle)) {
                this.scanCodeDynamicTask.settleByMonth();
            }
            if ("season".equals(cycle)) {
                this.scanCodeDynamicTask.settleBySeason();
            }
            if ("halfYear".equals(cycle)) {
                this.scanCodeDynamicTask.settleByHalfYear();
            }
            if ("year".equals(cycle)) {
                this.scanCodeDynamicTask.settleByYear();
            }
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

