/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.scan.cycle.local.service.dynamictask;

import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeTask;
import com.biz.crm.cps.business.policy.scan.cycle.local.service.ScanCodeTaskService;
import com.biz.crm.cps.business.policy.scan.sdk.common.enums.RewardTaskStatusEnum;
import com.biz.crm.cps.business.policy.scan.sdk.dto.CycleScanCodeTaskDto;
import com.biz.crm.cps.business.policy.sdk.dto.PolicyRewardConditionDto;
import com.biz.crm.cps.business.policy.sdk.service.observer.PolicyRewardServiceObserver;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ScanCodeDynamicTask {
    @Autowired
    private ScanCodeTaskService scanCodeTaskService;
    @Autowired
    private List<PolicyRewardServiceObserver> policyRewardServiceObservers;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    @DynamicTaskService(cornExpression="0 0 0 1 1/1 ?", taskDesc="\u6bcf\u65e5\u66f4\u65b0\u534f\u8bae\u72b6\u6001")
    public void settleByMonth() {
        Date endTime = new Date();
        Date starterTime = DateUtils.addMonths((Date)DateUtils.ceiling((Date)endTime, (int)2), (int)-2);
        CycleScanCodeTaskDto cycleScanCodeTaskDto = new CycleScanCodeTaskDto();
        cycleScanCodeTaskDto.setStarterTime(starterTime);
        cycleScanCodeTaskDto.setEndTime(endTime);
        cycleScanCodeTaskDto.setRewardCycle("month");
        cycleScanCodeTaskDto.setRewardStatus(RewardTaskStatusEnum.STATUS_WAIT.getCode());
        List<ScanCodeTask> scanCodeTasks = this.scanCodeTaskService.findByConditions(cycleScanCodeTaskDto);
        if (CollectionUtils.isEmpty(scanCodeTasks)) {
            return;
        }
        this.callRewardObservers(scanCodeTasks);
    }

    @Transactional
    @DynamicTaskService(cornExpression="0 0 0 1 1/3 ?", taskDesc="\u6bcf\u65e5\u66f4\u65b0\u534f\u8bae\u72b6\u6001")
    public void settleBySeason() {
        Date endTime = new Date();
        Date starterTime = DateUtils.addMonths((Date)DateUtils.ceiling((Date)endTime, (int)2), (int)-4);
        CycleScanCodeTaskDto cycleScanCodeTaskDto = new CycleScanCodeTaskDto();
        cycleScanCodeTaskDto.setStarterTime(starterTime);
        cycleScanCodeTaskDto.setEndTime(endTime);
        cycleScanCodeTaskDto.setRewardCycle("season");
        cycleScanCodeTaskDto.setRewardStatus(RewardTaskStatusEnum.STATUS_WAIT.getCode());
        List<ScanCodeTask> scanCodeTasks = this.scanCodeTaskService.findByConditions(cycleScanCodeTaskDto);
        if (CollectionUtils.isEmpty(scanCodeTasks)) {
            return;
        }
        this.callRewardObservers(scanCodeTasks);
    }

    @Transactional
    @DynamicTaskService(cornExpression="0 0 0 1 1/6 ?", taskDesc="\u6bcf\u65e5\u66f4\u65b0\u534f\u8bae\u72b6\u6001")
    public void settleByHalfYear() {
        Date endTime = new Date();
        Date starterTime = DateUtils.addMonths((Date)DateUtils.ceiling((Date)endTime, (int)2), (int)-7);
        CycleScanCodeTaskDto cycleScanCodeTaskDto = new CycleScanCodeTaskDto();
        cycleScanCodeTaskDto.setStarterTime(starterTime);
        cycleScanCodeTaskDto.setEndTime(endTime);
        cycleScanCodeTaskDto.setRewardCycle("halfYear");
        cycleScanCodeTaskDto.setRewardStatus(RewardTaskStatusEnum.STATUS_WAIT.getCode());
        List<ScanCodeTask> scanCodeTasks = this.scanCodeTaskService.findByConditions(cycleScanCodeTaskDto);
        if (CollectionUtils.isEmpty(scanCodeTasks)) {
            return;
        }
        this.callRewardObservers(scanCodeTasks);
    }

    @Transactional
    @DynamicTaskService(cornExpression="0 0 0 1 1 ?", taskDesc="\u6bcf\u65e5\u66f4\u65b0\u534f\u8bae\u72b6\u6001")
    public void settleByYear() {
        Date endTime = new Date();
        Date starterTime = DateUtils.addYears((Date)DateUtils.ceiling((Date)endTime, (int)1), (int)-2);
        CycleScanCodeTaskDto cycleScanCodeTaskDto = new CycleScanCodeTaskDto();
        cycleScanCodeTaskDto.setStarterTime(starterTime);
        cycleScanCodeTaskDto.setEndTime(endTime);
        cycleScanCodeTaskDto.setRewardCycle("year");
        cycleScanCodeTaskDto.setRewardStatus(RewardTaskStatusEnum.STATUS_WAIT.getCode());
        List<ScanCodeTask> scanCodeTasks = this.scanCodeTaskService.findByConditions(cycleScanCodeTaskDto);
        if (CollectionUtils.isEmpty(scanCodeTasks)) {
            return;
        }
        this.callRewardObservers(scanCodeTasks);
    }

    private void callRewardObservers(List<ScanCodeTask> scanCodeTasks) {
        if (CollectionUtils.isEmpty(this.policyRewardServiceObservers)) {
            return;
        }
        scanCodeTasks.stream().forEach(cycleScanCodeTask -> cycleScanCodeTask.setRewardStatus(RewardTaskStatusEnum.STATUS_COMPLETE.getCode()));
        this.scanCodeTaskService.updateBatch(scanCodeTasks);
        List policyRewardConditionDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(scanCodeTasks, ScanCodeTask.class, PolicyRewardConditionDto.class, HashSet.class, LinkedList.class, new String[0]);
        for (PolicyRewardServiceObserver rewardServiceObserver : this.policyRewardServiceObservers) {
            rewardServiceObserver.createRewardRecord(policyRewardConditionDtos);
        }
    }
}

