/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.scan.cycle.local.service.internal;

import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeEvent;
import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeExpression;
import com.biz.crm.cps.business.policy.scan.cycle.local.repository.ScanCodeExpressionRepository;
import com.biz.crm.cps.business.policy.scan.cycle.local.service.ScanCodeExpressionService;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeExpressionServiceImpl
implements ScanCodeExpressionService {
    @Autowired
    private ScanCodeExpressionRepository scanCodeExpressionRepository;

    @Override
    @Transactional
    public void create(ScanCodeEvent scanCodeEvent) {
        Validate.notNull((Object)((Object)scanCodeEvent), (String)"\u626b\u7801\u4e8b\u4ef6\u4fe1\u606f\u672a\u4f20", (Object[])new Object[0]);
        Set<ScanCodeExpression> scanCodeExpressions = scanCodeEvent.getScanCodeExpressions();
        Validate.isTrue((!CollectionUtils.isEmpty(scanCodeExpressions) ? 1 : 0) != 0, (String)"\u626b\u7801\u8868\u8fbe\u5f0f\u4fe1\u606f\u672a\u914d\u7f6e", (Object[])new Object[0]);
        for (ScanCodeExpression expression : scanCodeExpressions) {
            expression.setEventId(scanCodeEvent.getId());
            this.createValidation(expression);
        }
        this.scanCodeExpressionRepository.saveBatch(scanCodeExpressions);
        for (ScanCodeExpression scanCodeExpression : scanCodeExpressions) {
            Set<ScanCodeExpression> transferSet = scanCodeExpression.getScanCodeExpressions();
            if (CollectionUtils.isEmpty(transferSet)) continue;
            for (ScanCodeExpression transfer : transferSet) {
                transfer.setEventId(scanCodeEvent.getId());
                transfer.setExpressionId(scanCodeExpression.getId());
                this.createValidation(transfer);
            }
            this.scanCodeExpressionRepository.saveBatch(transferSet);
        }
    }

    private void createValidation(ScanCodeExpression entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        Validate.notBlank((CharSequence)entity.getEventId(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u626b\u7801\u4e8b\u4ef6\u7684ID \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRewardMethodFlag(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u6807\u5fd7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRewardMethodName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getAwardConditionFlag(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u6761\u4ef6\u6807\u5fd7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getAwardConditionName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u6761\u4ef6\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRewardData(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u6570\u636e \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRewardCycle(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u5468\u671f \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((entity.getEventId() == null || entity.getEventId().length() < 255 ? 1 : 0) != 0, (String)"\u626b\u7801\u4e8b\u4ef6\u7684ID ,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getExpressionId() == null || entity.getExpressionId().length() < 255 ? 1 : 0) != 0, (String)"\u4e0a\u7ea7id ,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getParticipatorFlag() == null || entity.getParticipatorFlag().length() < 16 ? 1 : 0) != 0, (String)"\u626b\u7801\u884c\u4e3a\u4e3b\u4f53(\u5206\u5229\u53c2\u4e0e\u8005 \u6807\u8bb0\uff09 ,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(16)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getParticipatorName() == null || entity.getParticipatorName().length() < 16 ? 1 : 0) != 0, (String)"\u626b\u7801\u884c\u4e3a\u4e3b\u4f53(\u5206\u5229\u53c2\u4e0e\u8005 \u4e2d\u6587\u540d\uff09 ,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(16)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getRewardMethodFlag() == null || entity.getRewardMethodFlag().length() < 16 ? 1 : 0) != 0, (String)"\u5956\u52b1\u65b9\u5f0f\u6807\u5fd7 ,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(16)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getRewardMethodName() == null || entity.getRewardMethodName().length() < 16 ? 1 : 0) != 0, (String)"\u5956\u52b1\u65b9\u5f0f\u540d\u79f0 ,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(16)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getAwardConditionFlag() == null || entity.getAwardConditionFlag().length() < 16 ? 1 : 0) != 0, (String)"\u5956\u52b1\u6761\u4ef6\u6807\u5fd7 ,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(16)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getAwardConditionName() == null || entity.getAwardConditionName().length() < 16 ? 1 : 0) != 0, (String)"\u5956\u52b1\u6761\u4ef6\u540d\u79f0 ,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(16)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getRewardData() == null || entity.getRewardData().length() < 255 ? 1 : 0) != 0, (String)"\u5956\u52b1\u6570\u636e ,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

