/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.scan.cycle.local.service.internal;

import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeTask;
import com.biz.crm.cps.business.policy.scan.cycle.local.repository.ScanCodeTaskRepository;
import com.biz.crm.cps.business.policy.scan.cycle.local.service.ScanCodeTaskService;
import com.biz.crm.cps.business.policy.scan.sdk.common.enums.RewardTaskStatusEnum;
import com.biz.crm.cps.business.policy.scan.sdk.dto.CycleScanCodeTaskDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeTaskServiceImpl
implements ScanCodeTaskService {
    @Autowired
    private ScanCodeTaskRepository scanCodeTaskRepository;

    @Override
    @Transactional
    public void createBatch(List<ScanCodeTask> scanCodeTasks) {
        if (CollectionUtils.isEmpty(scanCodeTasks)) {
            return;
        }
        Date date = new Date();
        for (ScanCodeTask scanCodeTask : scanCodeTasks) {
            scanCodeTask.setTenantCode(TenantUtils.getTenantCode());
            scanCodeTask.setRewardStatus(RewardTaskStatusEnum.STATUS_WAIT.getCode());
            scanCodeTask.setTaskTime(date);
            this.createValidation(scanCodeTask);
        }
        this.scanCodeTaskRepository.saveBatch(scanCodeTasks);
    }

    @Override
    public List<ScanCodeTask> findByConditions(CycleScanCodeTaskDto cycleScanCodeTaskDto) {
        if (cycleScanCodeTaskDto == null) {
            cycleScanCodeTaskDto = new CycleScanCodeTaskDto();
        }
        return this.scanCodeTaskRepository.findByConditions(cycleScanCodeTaskDto);
    }

    @Override
    @Transactional
    public void updateBatch(List<ScanCodeTask> scanCodeTasks) {
        if (CollectionUtils.isEmpty(scanCodeTasks)) {
            return;
        }
        for (ScanCodeTask scanCodeTask : scanCodeTasks) {
            this.updateValidation(scanCodeTask);
        }
        this.scanCodeTaskRepository.updateBatchById(scanCodeTasks);
    }

    private void createValidation(ScanCodeTask scanCodeTask) {
        Validate.notNull((Object)((Object)scanCodeTask), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        scanCodeTask.setId(null);
        Validate.notNull((Object)scanCodeTask.getTriggerAction(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u89e6\u53d1\u52a8\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getTriggerObject(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u89e6\u53d1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getActualParticipatorCode(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u53c2\u4e0e\u8005\u7f16\u7801\uff08\u5b9e\u9645\u626b\u7801\u8005\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getActualParticipatorFlag(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u53c2\u4e0e\u8005\u6807\u8bb0\uff08\u5b9e\u9645\u626b\u7801\u8005\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getAwardConditionFlag(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5956\u52b1\u6761\u4ef6\u6807\u5fd7(\u56fa\u5b9a\u989d\u5ea6\uff0c\u5b9a\u989d\u968f\u673a)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getAwardConditionName(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u51fa\u53d1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getRecordCode(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u626b\u7801\u8bb0\u5f55\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getRewardCycle(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5956\u52b1\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getRewardData(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5956\u52b1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getTemplateCode(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getRewardMethodFlag(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getRewardMethodName(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidation(ScanCodeTask scanCodeTask) {
        Validate.notNull((Object)((Object)scanCodeTask), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getId(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getTriggerAction(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u89e6\u53d1\u52a8\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getTriggerObject(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u89e6\u53d1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getActualParticipatorCode(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u53c2\u4e0e\u8005\u7f16\u7801\uff08\u5b9e\u9645\u626b\u7801\u8005\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getActualParticipatorFlag(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u53c2\u4e0e\u8005\u6807\u8bb0\uff08\u5b9e\u9645\u626b\u7801\u8005\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getAwardConditionFlag(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5956\u52b1\u6761\u4ef6\u6807\u5fd7(\u56fa\u5b9a\u989d\u5ea6\uff0c\u5b9a\u989d\u968f\u673a)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getAwardConditionName(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u51fa\u53d1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getRecordCode(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u626b\u7801\u8bb0\u5f55\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getRewardCycle(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5956\u52b1\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getRewardData(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5956\u52b1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getTemplateCode(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getRewardMethodFlag(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeTask.getRewardMethodName(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

