/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.scan.cycle.local.service.observer;

import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeConfiguration;
import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeRange;
import com.biz.crm.cps.business.policy.scan.cycle.local.service.ScanCodeConfigurationService;
import com.biz.crm.cps.business.product.sdk.common.enums.MaterialDimensionEnum;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeVerifyEventListener;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ScanCodeEventListenerImpl
implements ScanCodeVerifyEventListener {
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private ScanCodeConfigurationService scanCodeConfigurationService;
    @Autowired
    private MaterialVoService materialVoService;

    public void checkBarcode(ScanCodeExceptionStrategyDto dto) {
        LoginUserAgreementDto agreementDto = new LoginUserAgreementDto();
        if (dto.getParticipatorType().equals(ParticipatorTypeEnum.DEALER.getKey())) {
            agreementDto.setCustomerCode(dto.getScanParticipatorCode());
        } else {
            agreementDto.setTerminalCode(dto.getScanParticipatorCode());
        }
        List agreementVos = this.agreementVoService.findByConditions(agreementDto);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)agreementVos) ? 1 : 0) != 0, (String)"\u626b\u7801\u4eba\u672a\u7b7e\u7f72\u4efb\u4f55\u534f\u8bae", (Object[])new Object[0]);
        Set<String> agreementCodes = agreementVos.stream().map(AgreementVo::getTemplateCode).collect(Collectors.toSet());
        List<ScanCodeConfiguration> codeConfigurations = this.scanCodeConfigurationService.findDetailsByTemplateCodes(agreementCodes);
        Validate.isTrue((!CollectionUtils.isEmpty(codeConfigurations) ? 1 : 0) != 0, (String)"\u626b\u7801\u4eba\u7b7e\u7f72\u7684\u534f\u8bae\u5df2\u7ecf\u5931\u6548", (Object[])new Object[0]);
        boolean checkSuccess = false;
        for (ScanCodeConfiguration config : codeConfigurations) {
            if (MaterialDimensionEnum.ALL.getKey().equals(config.getDimensionFlag())) {
                checkSuccess = true;
                break;
            }
            List dimensionCodes = config.getScanCodeRanges().stream().map(ScanCodeRange::getSpecialCode).collect(Collectors.toList());
            List materialCodes = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(dimensionCodes, config.getDimensionFlag());
            if (CollectionUtils.isEmpty((Collection)materialCodes) || !materialCodes.contains(dto.getProductCode())) continue;
            checkSuccess = true;
            break;
        }
        Validate.isTrue((boolean)checkSuccess, (String)"\u672c\u6b21\u626b\u7801\u7269\u6599\u672a\u5b58\u5728\u5df2\u7b7e\u7f72\u534f\u8bae\u4e2d", (Object[])new Object[0]);
    }
}

