package com.biz.crm.cps.business.policy.scan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 扫码政策的产品范围
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeRange", description = "扫码政策的产品范围")
@TableName("scan_code_range")
public class ScanCodeRange extends BaseIdEntity {

  private static final long serialVersionUID = -6565648247353508111L;

  /**
   * 扫码政策配置行
   *  @JoinColumn(name = "configuration_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 扫码政策配置行 '")
   *  @ManyToOne(fetch = FetchType.LAZY)
   */
  @ApiModelProperty("扫码政策配置行")
  @TableField(exist = false)
  private ScanCodeConfiguration scanCodeConfiguration;

  /**
   * 配置行ID
   *   @Column(name = "configuration_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 配置行ID '")
   */
  @ApiModelProperty("配置行ID")
  @TableField(value = "configuration_id")
  private String configurationId;

  /**
   * 有特定业务含义的标识字符串(特征编码，比如：品牌编码、系列编码)
   *   @Column(name = "special_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 有特定业务含义的标识字符串(特征编码，比如：品牌编码、系列编码) '")
   */
  @ApiModelProperty("有特定业务含义的标识字符串(特征编码，比如：品牌编码、系列编码)")
  @TableField(value = "special_code")
  private String specialCode;

  /**
   * 汉字名称
   *   @Column(name = "special_name", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 汉字名称 '")
   */
  @ApiModelProperty("汉字名称")
  @TableField(value = "special_name")
  private String specialName;

}
