package com.biz.crm.cps.business.policy.scan.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeConfiguration;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * Terminal 的 mybatis 操作接口
 * @Author: hefan
 */
public interface ScanCodeConfigurationMapper extends BaseMapper<ScanCodeConfiguration> {

  /**
   * 根据模板集合查询配置信息（包括关联表信息）
   * @param templateCodes
   * @param tenantCode
   * @return
   */
  List<ScanCodeConfiguration> findDetailsByTemplateCodes(@Param("templateCodes") Set<String> templateCodes, @Param("tenantCode") String tenantCode);

  /**
   * 根据模板查询配置信息（包括关联表信息）
   * @param templateCode
   * @param tenantCode
   * @return
   */
  List<ScanCodeConfiguration> findDetailsByTemplateCode(@Param("templateCode") String templateCode, @Param("tenantCode") String tenantCode);
}
