package com.biz.crm.cps.business.policy.scan.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeConfiguration;
import com.biz.crm.cps.business.policy.scan.local.mapper.ScanCodeConfigurationMapper;

import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 扫码配置行的数据库操作类
 * @author hefan
 */
@Component
public class ScanCodeConfigurationRepository extends ServiceImpl<ScanCodeConfigurationMapper, ScanCodeConfiguration> {


  /**
   * 根据模板集合查询配置信息（包括关联表信息）
   * @param templateCodes
   * @param tenantCode
   * @return
   */
  public List<ScanCodeConfiguration> findDetailsByTemplateCodes(Set<String> templateCodes, String tenantCode) {
    return this.baseMapper.findDetailsByTemplateCodes(templateCodes, tenantCode);
  }

  /**
   * 根据模板查询配置信息（包括关联表信息）
   * @param templateCode
   * @param tenantCode
   * @return
   */
  public List<ScanCodeConfiguration> findDetailsByTemplateCode(String templateCode, String tenantCode) {
    return this.baseMapper.findDetailsByTemplateCode(templateCode, tenantCode);
  }
}
