package com.biz.crm.cps.business.policy.scan.local.service;

import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeConfiguration;

import java.util.List;
import java.util.Set;

/**
 * 扫码政策配置行
 * @author hefan
 */
public interface ScanCodeConfigurationService {

  /**
   * 从请求对象中获取信息，并保存到数据库
   * @param agreementPolicyDto
   * @return
   */
  ScanCodeConfiguration create(AgreementPolicyDto agreementPolicyDto);

  /**
   * 批量模板编号查询详细
   * @param templateCodes
   * @return
   */
  List<ScanCodeConfiguration> findDetailsByTemplateCodes(Set<String> templateCodes);

  /**
   * 根据模板编号查询详细
   * @param templateCode
   * @return
   */
  List<ScanCodeConfiguration> findDetailsByTemplateCode(String templateCode);

  /**
   * 创建扫码政策时验证物料重复
   * @param agreementTemplateVo 模板vo
   * @param agreementPolicyDto 政策vo
   */
  void validatePolicyScope(AgreementTemplateVo agreementTemplateVo, AgreementPolicyDto agreementPolicyDto);

}
