package com.biz.crm.cps.business.policy.scan.local.service.observer;

import com.biz.crm.cps.business.policy.scan.sdk.common.enums.ScanCodeActionEnum;
import com.biz.crm.cps.business.policy.sdk.service.observer.TriggerActionMountObserver;
import com.biz.crm.cps.external.mdm.sdk.service.DictMdmService;
import com.biz.crm.cps.external.mdm.sdk.service.UnionFuncEnumApi;
import com.biz.crm.cps.external.mdm.sdk.vo.DictVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/**
 * 扫码触发动作挂载观测者实现类
 * @author hefan
 */
@Component
public class ScanCodeTriggerActionMountObserverImpl implements TriggerActionMountObserver {

  @Autowired(required = false)
  private DictMdmService dictMdmService;

  @Override
  public Collection<DictVo> find() {
    UnionFuncEnumApi<DictVo> enumFuncApi = (var1, var2)->{
      List<DictVo> list = Lists.newLinkedList();
      Set<String> set = new TreeSet<>();
      this.filter(var1, list, set);
      this.filter(var2, list, set);
      return list;
    };
    return ScanCodeActionEnum.union(dictMdmService, enumFuncApi);
  }

  /**
   * 过滤集合
   * @param var1
   * @param list
   * @param set
   */
  private void filter(Collection<DictVo> var1, List<DictVo> list, Set<String> set) {
    for (DictVo dictVo : var1) {
      if (!set.contains(dictVo.getDictCode())) {
        list.add(dictVo);
        set.add(dictVo.getDictCode());
      }
    }
  }
}
