package com.biz.crm.cps.business.policy.scan.sdk.common.enums;

import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

/**
 * 返利类型枚举
 *
 * @author hefan
 */
public enum RebateTypeEnum {
  /** 返利类型枚举 */
  FORWARD("forward", "forward", "扫码政策分利", "1"),

  REVERSE("reverse", "reverse", "返利", "2"),

  SCAN_ACTIVITY_FORWARD("scan_activity_forward", "scan_activity_forward", "扫码活动分利", "3"),

  SCAN_ACTIVITY_REVERSE("scan_activity_reverse", "scan_activity_reverse", "扫码活动返利", "4"),
  ;

  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;

  /** 返利 */
  private static final String TYPE1 = "0";
  /** 分利 */
  private static final String TYPE2 = "1";

  RebateTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  /**
   * 根据key获取枚举
   *
   * @param key
   * @return
   */
  public static RebateTypeEnum findByKey(String key) {
    if (StringUtils.isBlank(key)) {
      return null;
    }
    return Stream.of(RebateTypeEnum.values())
        .filter(a -> key.equals(a.key))
        .findFirst()
        .orElse(null);
  }

  /**
   * 返回分利返利状态
   *
   * @param value
   * @return
   */
  public static String findTypeByValue(String value) {
    RebateTypeEnum rebateTypeEnum =
        Stream.of(RebateTypeEnum.values())
            .filter(a -> value.equals(a.value))
            .findFirst()
            .orElse(FORWARD);
    if (rebateTypeEnum.equals(FORWARD) || rebateTypeEnum.equals(SCAN_ACTIVITY_FORWARD)) {
      return TYPE1;
    }
    return TYPE2;
  }

  public static String getDictTypeCode() {
    return "RebateTypeEnum";
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }
}
