package com.biz.crm.cps.business.policy.scan.sdk.common.enums;

/**
 * @author jerry7
 * 扫码任务状态枚举
 */
public enum RewardTaskStatusEnum {

  /**
   * 未开始
   */
  STATUS_WAIT("0", "未开始"),

  /**
   * 已完成/已分利
   */
  STATUS_COMPLETE("2", "已完成/已分利"),

  /**
   * 已过期
   */
  STATUS_EXPIRED("3", "已过期");

  private String code;

  private String desc;

  private RewardTaskStatusEnum(String code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  public String getCode() {
    return code;
  }

  public String getDesc() {
    return desc;
  }
}
