package com.biz.crm.cps.business.policy.scan.sdk.common.enums;

import com.biz.crm.cps.external.mdm.sdk.service.DictMdmService;
import com.biz.crm.cps.external.mdm.sdk.service.UnionFuncEnumApi;
import com.biz.crm.cps.external.mdm.sdk.service.UnionMdmDictEnumApi;
import com.biz.crm.cps.external.mdm.sdk.vo.DictVo;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Objects;

/**
 * 扫码动作枚举
 *
 * @author hefan
 */
public enum ScanCodeActionEnum implements UnionMdmDictEnumApi {
  /**
   *
   */
  BOX_CODE("boxCode", "boxCode", "扫箱码", "3"),

  /**
   *
   */
  COVER_CODE("coverCode", "coverCode", "扫盖内码", "4"),

  /**
   *
   */
  CASE_CODE("caseCode", "caseCode", "扫盒码", "5"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ScanCodeActionEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public static String getDictTypeCode() {
    return "scanCodeActionEnum";
  }

  public static Collection<DictVo> findFromSelf() {
    ScanCodeActionEnum[] values = ScanCodeActionEnum.values();
    List<DictVo> list = Lists.newLinkedList();
    for (ScanCodeActionEnum value : values) {
      DictVo vo = new DictVo();
      vo.setDictCode(value.getDictCode());
      vo.setDictValue(value.getValue());
      vo.setDictSort(Integer.valueOf(value.getOrder()));
      list.add(vo);
    }
    return list;
  }

  /**
   * 获取该枚举在系统字典中配置的同名信息
   *
   * @param dictMdmService
   * @return
   */
  public static Collection<DictVo> findFromDictMdm(DictMdmService dictMdmService) {
    if (Objects.isNull(dictMdmService)) {
      return Lists.newLinkedList();
    }
    return dictMdmService.findByTypeCode(getDictTypeCode());
  }

  /**
   * 将代码内的枚举转成字典格式，与mdm系统中的数据字典合并
   *
   * @param dictMdmService
   * @return
   */
  public static Collection<DictVo> union(DictMdmService dictMdmService, UnionFuncEnumApi<DictVo> enumFuncApi) {
    Collection<DictVo> self = findFromSelf();
    Collection<DictVo> fromDictMdm = findFromDictMdm(dictMdmService);
    if (CollectionUtils.isEmpty(fromDictMdm)) {
      fromDictMdm = Lists.newLinkedList();
    }
    // 取并的时候，相同规则
    Collection<DictVo> union;
    if (Objects.nonNull(enumFuncApi)) {
      union = enumFuncApi.union(self, fromDictMdm);
    } else {
      union = CollectionUtils.union(self, fromDictMdm);
    }
    return union;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }
}
