package com.biz.crm.cps.business.policy.scan.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 扫码任务dto
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CycleScanCodeTaskDto", description = "扫码任务dto")
public class CycleScanCodeTaskDto {

  /**
   * 任务开始时间
   */
  @ApiModelProperty("任务开始时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date starterTime;

  /**
   * 任务开始时间
   */
  @ApiModelProperty("任务结束时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date endTime;

  /**
   * 奖励周期
   */
  @ApiModelProperty("奖励周期")
  private String rewardCycle;

  /**
   * 奖励状态
   * @see com.biz.crm.cps.business.policy.scan.sdk.common.enums.RewardTaskStatusEnum
   */
  @ApiModelProperty("任务状态")
  private String rewardStatus;

}
