package com.biz.crm.cps.business.policy.scan.sdk.dto;

import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 扫码政策配置行 Dto
 * @Author: hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeConfigurationDto", description = "扫码政策配置行")
public class ScanCodeConfigurationDto extends AgreementPolicyDto {

  private static final long serialVersionUID = -4239347976132715664L;

  /**
   * id
   */
  private String id;

  /**
   * 扫码产品维度标识
   */
  @ApiModelProperty("扫码产品维度标识")
  private String dimensionFlag;

  /**
   * 扫码产品维度名称
   */
  @ApiModelProperty("扫码产品维度名称")
  private String dimensionName;

  /**
   * 扫码参与者
   * @OneToMany(fetch = FetchType.LAZY,mappedBy = "scanCodeConfiguration")
   */
  @ApiModelProperty("扫码参与者")
  private Set<ScanCodeParticipatorDto> scanCodeParticipators;

  /**
   * 扫码政策的产品范围
   * @OneToMany(fetch = FetchType.LAZY,mappedBy = "scanCodeConfiguration")
   */
  @ApiModelProperty("扫码政策的产品范围")
  private Set<ScanCodeRangeDto> scanCodeRanges;

}
