package com.biz.crm.cps.business.policy.scan.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * 扫码分利表达式
 * @author hefan
 */
@Data
@ApiModel(value = "ScanCodeExpresionDto", description = "扫码分利表达式")
public class ScanCodeExpresionDto implements Serializable {
  private static final long serialVersionUID = -5230601649398005325L;

  /**
   * 条码类型（箱、瓶、盖 标记）
   */
  @ApiModelProperty("条码类型（箱、瓶、盖 标记）")
  private String barCodeTypeFlag;

  /**
   * 条码类型（箱、瓶、盖 中文名）
   */
  @ApiModelProperty("条码类型（箱、瓶、盖 中文名）")
  private String barCodeTypeName;

  /**
   * 扫码行为主体(分利参与者 标记）
   */
  @ApiModelProperty("扫码行为主体(分利参与者 标记）")
  private String participatorFlag;

  /**
   * 扫码行为主体(分利参与者 中文名）
   */
  @ApiModelProperty("扫码行为主体(分利参与者 中文名）")
  private String participatorName;

  /**
   * 奖励方式标志
   */
  @ApiModelProperty("奖励方式标志")
  private String rewardMethodFlag;

  /**
   * 奖励方式名称
   */
  @ApiModelProperty("奖励方式名称")
  private String rewardMethodName;

  /**
   * 奖励条件标志
   */
  @ApiModelProperty("奖励条件标志")
  private String awardConditionFlag;

  /**
   * 奖励条件名称
   */
  @ApiModelProperty("奖励条件名称")
  private String awardConditionName;

  /**
   * 奖励数据
   */
  @ApiModelProperty("奖励数据")
  private String rewardData;

  /**
   * 奖励周期 (current-实时、month-月、season-季度、halfYear-半年、year-年)
   */
  @ApiModelProperty("奖励周期")
  private String rewardCycle;

  /**
   * 扫码分利表达式
   */
  @ApiModelProperty("扫码分利表达式")
  private Set<ScanCodeExpresionDto> scanCodeExpressions;

}
