package com.biz.crm.cps.business.policy.scan.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * 扫码参与者
 * @author hefan
 */
@Data
@ApiModel(value = "ScanCodeParticipatorDto", description = "扫码参与者")
public class ScanCodeParticipatorDto implements Serializable {
  private static final long serialVersionUID = -4080570587383901574L;

  /**
   * 扫码行为主体(分利参与者 标记）
   */
  @ApiModelProperty("扫码行为主体(分利参与者 标记）")
  private String participatorFlag;

  /**
   * 扫码行为主体(分利参与者 中文名）
   */
  @ApiModelProperty("扫码行为主体(分利参与者 中文名）")
  private String participatorName;

  /**
   * 扫码分利表达式
   */
  @ApiModelProperty("扫码分利表达式")
  private Set<ScanCodeExpresionDto> scanCodeExpressions;
}
