package com.biz.crm.cps.business.policy.scan.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 扫码政策的产品范围
 * @author hefan
 */
@Data
@ApiModel(value = "ScanCodeRangeDto", description = "扫码政策的产品范围")
public class ScanCodeRangeDto implements Serializable {
  private static final long serialVersionUID = 2167106946843262505L;

  /**
   * 有特定业务含义的标识字符串(特征编码，比如：品牌编码、系列编码)
   */
  @ApiModelProperty("有特定业务含义的标识字符串(特征编码，比如：品牌编码、系列编码)")
  private String specialCode;

  /**
   * 汉字名称
   */
  @ApiModelProperty("汉字名称")
  private String specialName;


}
