package com.biz.crm.cps.business.policy.scan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 扫码政策配置行 Vo
 *
 * @Author: hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeConfigurationVo", description = "扫码政策配置行")
public class ScanCodeConfigurationVo extends TenantOpVo {

  private static final long serialVersionUID = -4239347976132715664L;

  /**
   * 扫码产品维度标识
   */
  @ApiModelProperty("扫码产品维度标识")
  private String dimensionFlag;

  /**
   * 扫码产品维度名称
   */
  @ApiModelProperty("扫码产品维度名称")
  private String dimensionName;

  /**
   * 扫码参与者
   * @OneToMany(fetch = FetchType.LAZY,mappedBy = "scanCodeConfiguration")
   */
  @ApiModelProperty("扫码参与者")
  private Set<ScanCodeParticipatorVo> scanCodeParticipators;

  /**
   * 扫码政策的产品范围
   * @OneToMany(fetch = FetchType.LAZY,mappedBy = "scanCodeConfiguration")
   */
  @ApiModelProperty("扫码政策的产品范围")
  private Set<ScanCodeRangeVo> scanCodeRanges;

}

