package com.biz.crm.cps.business.policy.scan.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 扫码参与者
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeParticipatorVo", description = "扫码参与者")
public class ScanCodeParticipatorVo extends BaseIdVo {
  private static final long serialVersionUID = 7354472778404866473L;

  /**
   * 扫码行为主体(分利参与者 标记）
   */
  @ApiModelProperty("扫码行为主体(分利参与者 标记）")
  private String participatorFlag;

  /**
   * 扫码行为主体(分利参与者 中文名）
   */
  @ApiModelProperty("扫码行为主体(分利参与者 中文名）")
  private String participatorName;

  /**
   * 扫码分利表达式
   */
  @ApiModelProperty("扫码分利表达式")
  private Set<ScanCodeExpresionVo> scanCodeExpressions;
}

