package com.biz.crm.cps.business.policy.scan.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 扫码政策的产品范围
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeRangeVo", description = "扫码政策的产品范围")
public class ScanCodeRangeVo extends BaseIdVo {

  /**
   * 
   */
  private static final long serialVersionUID = -1163096896896548625L;

  /**
   * 配置行ID
   */
  @ApiModelProperty("配置行ID")
  private String configurationId;

  /**
   * 有特定业务含义的标识字符串(特征编码，比如：品牌编码、系列编码)
   */
  @ApiModelProperty("有特定业务含义的标识字符串(特征编码，比如：品牌编码、系列编码)")
  private String specialCode;

  /**
   * 汉字名称
   */
  @ApiModelProperty("汉字名称")
  private String specialName;


}