package com.biz.crm.cps.business.price.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.price.local.service.ControlProductPriceService;
import com.biz.crm.cps.business.price.sdk.dto.ControlProductPriceDto;
import com.biz.crm.cps.business.price.sdk.vo.ControlProductPriceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 控制商品价格
 * @Author: zengxingwang
 * @Date: 2021/7/20 10:49
 */
@Api(tags = "控制商品价格")
@Slf4j
@RestController
@RequestMapping("/v1/price/controlProductPrice")
public class ControlProductPriceController {

  @Autowired
  private ControlProductPriceService controlProductPriceService;

  /**
   * 配置控价商品
   */
  @ApiOperation(value = "配置控价商品")
  @PostMapping(value="")
  public Result<?> create(@RequestBody @ApiParam(name="dto" , value="控价商品请求dto") ControlProductPriceDto dto) {
    try {
      controlProductPriceService.create(dto);
      return Result.ok();
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 条件查询控价商品列表
   */
  @ApiOperation(value = "条件查询控价商品列表")
  @GetMapping(value="findByConditions")
  public Result<Page<ControlProductPriceVo>> findByConditions(@RequestBody @ApiParam(name="dto" , value="控价商品请求dto") ControlProductPriceDto dto,
                                               @PageableDefault(50) Pageable pageable) {
    try {
      Page<ControlProductPriceVo> vos = controlProductPriceService.findByConditions(dto, pageable);
      return Result.ok(vos);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量根据ids启用
   */
  @ApiOperation(value = "批量根据ids启用")
  @PatchMapping(value="enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      controlProductPriceService.enable(ids);
      return Result.ok("启用成功");
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量根据id禁用
   */
  @ApiOperation(value = "批量根据id禁用")
  @PatchMapping(value="disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      controlProductPriceService.disable(ids);
      return Result.ok("禁用成功");
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}
