package com.biz.crm.cps.business.price.local.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 控制商品价格实体
 * @Author: zengxingwang
 * @Date: 2021/7/20 10:34
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ControlProductPriceEntity", description = "控制商品价格实体")
@TableName("control_product_price")
public class ControlProductPriceEntity extends TenantFlagOpEntity {
  
  private static final long serialVersionUID = 945180464401339477L;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  @TableField(value = "material_code")
  private String materialCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  @TableField(value = "material_name")
  private String materialName;

  /**
   * 商品图片
   */
  @ApiModelProperty("商品图片")
  @TableField(value = "file_code")
  private String fileCode;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  @TableField(value = "sale_unit")
  private String saleUnit;

  /**
   * 建议销售价
   */
  @ApiModelProperty("建议销售价")
  @TableField(value = "suggested_price")
  private BigDecimal suggestedPrice;

  /**
   * 底价
   */
  @ApiModelProperty("底价")
  @TableField(value = "base_price")
  private BigDecimal basePrice;

  /**
   * 物料层级
   */
  @ApiModelProperty("物料层级")
  @TableField(value = "product_level_code")
  private String productLevelCode;

  /**
   * 成本价
   */
  @ApiModelProperty("成本价")
  @TableField(value = "cost_price")
  private BigDecimal costPrice;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  @TableField(value = "specification")
  private String specification;

  /**
   * 销售组织编码
   */
  @ApiModelProperty("销售组织编码")
  @TableField(value = "sale_org_code")
  private String saleOrgCode;

  /**
   * 销售组织名称
   */
  @ApiModelProperty("销售组织名称")
  @TableField(value = "sale_org_name")
  private String saleOrgName;
}
