package com.biz.crm.cps.business.price.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.price.local.entity.ControlProductPriceEntity;
import com.biz.crm.cps.business.price.local.mapper.ControlProductPriceMapper;
import com.biz.crm.cps.business.price.sdk.dto.ControlProductPriceDto;
import com.biz.crm.cps.business.price.sdk.vo.ControlProductPriceVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/7/21 15:33
 */
@Component
public class ControlProductPriceRepository extends ServiceImpl<ControlProductPriceMapper, ControlProductPriceEntity> {

  @Resource
  private ControlProductPriceMapper controlProductPriceMapper;

  public ControlProductPriceEntity findByMaterialCode(String materialCode) {
    if(StringUtils.isBlank(materialCode)){
      return null;
    }
    QueryWrapper<ControlProductPriceEntity> wrapper = new QueryWrapper<>();
    wrapper.eq("material_code", materialCode);
    return controlProductPriceMapper.selectOne(wrapper);
  }

  public Page<ControlProductPriceVo> findByConditions(ControlProductPriceDto dto, Pageable pageable) {
    Page<ControlProductPriceVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return controlProductPriceMapper.findByConditions(page, dto);
  }

  public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    UpdateWrapper<ControlProductPriceEntity> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("enable_status", enable.getCode());
    updateWrapper.in("id", ids);
    this.update(updateWrapper);
  }

  public long findByMaterialCodeIn(List<String> materialCodes) {
    if (CollectionUtils.isEmpty(materialCodes)) {
      return 0L;
    }
    UpdateWrapper<ControlProductPriceEntity> updateWrapper = new UpdateWrapper<>();
    updateWrapper.in("material_code", materialCodes);
    return this.count(updateWrapper);
  }

  public List<ControlProductPriceEntity> findByIds(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return null;
    }
    QueryWrapper<ControlProductPriceEntity> wrapper = new QueryWrapper<>();
    wrapper.in("id", ids);
    return this.list(wrapper);
  }
}
