package com.biz.crm.cps.business.price.local.service;

import com.biz.crm.cps.business.price.sdk.dto.ControlProductPriceDto;
import com.biz.crm.cps.business.price.sdk.vo.ControlProductPriceVo;
import org.springframework.data.domain.Pageable;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 控价商品定价接口定义
 * @Author: zengxingwang
 * @Date: 2021/7/20 10:58
 */
public interface ControlProductPriceService {

  /**
   * 配置控价商品
   * @param dto
   * @return
   */
  void create(ControlProductPriceDto dto);

  /**
   * 根据id启用
   * @param ids
   */
  void enable(List<String> ids);

  /**
   * 根据id禁用
   * @param ids
   */
  void disable(List<String> ids);

  /**
   * 条件查询控价商品列表
   * @param dto
   * @return
   */
  Page<ControlProductPriceVo> findByConditions(ControlProductPriceDto dto, Pageable pageable);
}
