/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.price.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.price.local.entity.ControlProductPriceEntity;
import com.biz.crm.cps.business.price.local.mapper.ControlProductPriceMapper;
import com.biz.crm.cps.business.price.sdk.dto.ControlProductPriceDto;
import com.biz.crm.cps.business.price.sdk.vo.ControlProductPriceVo;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ControlProductPriceRepository
extends ServiceImpl<ControlProductPriceMapper, ControlProductPriceEntity> {
    @Resource
    private ControlProductPriceMapper controlProductPriceMapper;

    public ControlProductPriceEntity findByMaterialCode(String materialCode) {
        if (StringUtils.isBlank((CharSequence)materialCode)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"material_code", (Object)materialCode);
        return (ControlProductPriceEntity)((Object)this.controlProductPriceMapper.selectOne((Wrapper)wrapper));
    }

    public Page<ControlProductPriceVo> findByConditions(ControlProductPriceDto dto, Pageable pageable) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.controlProductPriceMapper.findByConditions((Page<ControlProductPriceVo>)page, dto);
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public long findByMaterialCodeIn(List<String> materialCodes) {
        if (CollectionUtils.isEmpty(materialCodes)) {
            return 0L;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"material_code", materialCodes);
        return this.count((Wrapper)updateWrapper);
    }

    public List<ControlProductPriceEntity> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id", ids);
        return this.list((Wrapper)wrapper);
    }
}

