/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.price.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.price.local.entity.ControlProductPriceEntity;
import com.biz.crm.cps.business.price.local.repository.ControlProductPriceRepository;
import com.biz.crm.cps.business.price.local.service.ControlProductPriceService;
import com.biz.crm.cps.business.price.sdk.dto.ControlProductPriceDto;
import com.biz.crm.cps.business.price.sdk.event.ControlProductPriceEventListener;
import com.biz.crm.cps.business.price.sdk.vo.ControlProductPriceOrgMappingVo;
import com.biz.crm.cps.business.price.sdk.vo.ControlProductPriceVo;
import com.biz.crm.cps.business.price.sdk.vo.ProductPriceVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"ControlProductPriceExpandImpl"})
public class ControlProductPriceServiceImpl
implements ControlProductPriceService {
    @Autowired
    private ControlProductPriceRepository controlProductPriceRepository;
    @Autowired(required=false)
    private List<ControlProductPriceEventListener> controlProductPriceEventListeners;

    @Override
    @Transactional
    public void create(ControlProductPriceDto dto) {
        this.validate(dto);
        Set productPriceOrgMappings = dto.getProductPriceOrgMappings();
        String SaleOrgName = "";
        String SaleOrgCode = "";
        for (ControlProductPriceOrgMappingVo productPriceOrgMapping : productPriceOrgMappings) {
            SaleOrgName = StringUtils.join((Object[])new String[]{SaleOrgName, ",", productPriceOrgMapping.getSaleOrgName()});
            SaleOrgCode = StringUtils.join((Object[])new String[]{SaleOrgCode, ",", productPriceOrgMapping.getSaleOrgCode()});
        }
        Set products = dto.getProducts();
        ArrayList<String> materialCodes = new ArrayList<String>();
        for (ProductPriceVo vo : products) {
            materialCodes.add(vo.getMaterialCode());
        }
        long count = this.controlProductPriceRepository.findByMaterialCodeIn(materialCodes);
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u914d\u7f6e\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ArrayList<ControlProductPriceEntity> productList = new ArrayList<ControlProductPriceEntity>();
        for (ProductPriceVo productPriceVo : products) {
            ControlProductPriceEntity entity = new ControlProductPriceEntity();
            BeanUtils.copyProperties((Object)productPriceVo, (Object)((Object)entity));
            entity.setSaleOrgName(SaleOrgName.substring(1));
            entity.setSaleOrgCode(SaleOrgCode.substring(1));
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            productList.add(entity);
        }
        this.controlProductPriceRepository.saveBatch(productList);
        if (this.controlProductPriceEventListeners != null) {
            for (ControlProductPriceEventListener eventListener : this.controlProductPriceEventListeners) {
                eventListener.onCreate(materialCodes);
            }
        }
    }

    @Override
    @Transactional
    public void enable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u542f\u7528\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.controlProductPriceRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7981\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ControlProductPriceEntity> controlProductPriceEntities = this.controlProductPriceRepository.findByIds(ids);
        if (CollectionUtils.isNotEmpty(controlProductPriceEntities)) {
            ArrayList<String> materialCodes = new ArrayList<String>();
            for (ControlProductPriceEntity entity : controlProductPriceEntities) {
                materialCodes.add(entity.getMaterialCode());
            }
            if (this.controlProductPriceEventListeners != null) {
                for (ControlProductPriceEventListener eventListener : this.controlProductPriceEventListeners) {
                    Boolean bool = eventListener.onDisable(materialCodes);
                    Validate.isTrue((boolean)bool, (String)"\u4e0d\u53ef\u7981\u7528", (Object[])new Object[0]);
                }
            }
        }
        this.controlProductPriceRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    public Page<ControlProductPriceVo> findByConditions(ControlProductPriceDto dto, Pageable pageable) {
        return this.controlProductPriceRepository.findByConditions(dto, pageable);
    }

    private void validate(ControlProductPriceDto dto) {
        Validate.notNull((Object)dto, (String)"\u914d\u7f6e\u63a7\u4ef7\u4ea7\u54c1\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set productPriceOrgMappings = dto.getProductPriceOrgMappings();
        Validate.notEmpty((Collection)productPriceOrgMappings, (String)"\u9500\u552e\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ControlProductPriceOrgMappingVo productPriceOrgMapping : productPriceOrgMappings) {
            Validate.notBlank((CharSequence)productPriceOrgMapping.getSaleOrgCode(), (String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)productPriceOrgMapping.getSaleOrgName(), (String)"\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Set products = dto.getProducts();
        Validate.notEmpty((Collection)products, (String)"\u7269\u6599\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ProductPriceVo productPriceVo : products) {
            Validate.notBlank((CharSequence)productPriceVo.getMaterialCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)productPriceVo.getSuggestedPrice(), (String)"\u5efa\u8bae\u9500\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)productPriceVo.getBasePrice(), (String)"\u4f4e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

