package com.biz.crm.cps.business.price.sdk.dto;

import com.biz.crm.cps.business.price.sdk.vo.ControlProductPriceOrgMappingVo;
import com.biz.crm.cps.business.price.sdk.vo.ProductPriceVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Set;

/**
 * 控制商品价格创建dto
 * @Author: zengxingwang
 * @Date: 2021/7/20 14:19
 */
@Data
@ApiModel(description = "控制商品价格创建dto")
public class ControlProductPriceDto {

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String materialCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String materialName;

  /**
   * 状态
   */
  @ApiModelProperty("状态")
  private String status;

  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String orgCode;

  /**
   * 销售区域
   */
  @ApiModelProperty("销售区域")
  private Set<ControlProductPriceOrgMappingVo> productPriceOrgMappings;

  /**
   * 商品信息
   */
  @ApiModelProperty("商品信息")
  private Set<ProductPriceVo> products;
}
