package com.biz.crm.cps.business.price.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 控制商品价格vo
 * @Author: zengxingwang
 * @Date: 2021/7/20 10:22
 */
@Data
@ApiModel(description = "控制商品价格vo")
public class ControlProductPriceVo {

  /**
   * 主键
   */
  @ApiModelProperty("主键")
  private String id;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String materialCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String materialName;

  /**
   * 商品图片
   */
  @ApiModelProperty("商品图片")
  private String imgUrl;

  /**
   * 销售组织编码
   */
  @ApiModelProperty("销售组织编码")
  private String saleOrgCode;

  /**
   * 销售组织名称
   */
  @ApiModelProperty("销售组织名称")
  private String saleOrgName;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String saleUnit;

  /**
   * 建议销售价
   */
  @ApiModelProperty("建议销售价")
  private BigDecimal suggestedPrice;

  /**
   * 底价
   */
  @ApiModelProperty("底价")
  private BigDecimal basePrice;

  /**
   * 物料层级
   */
  @ApiModelProperty("物料层级")
  private String productLevelCode;

  /**
   * 成本价
   */
  @ApiModelProperty("成本价")
  private BigDecimal costPrice;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String specification;
}
