package com.biz.crm.cps.business.price.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 商品价格vo
 * @Author: zengxingwang
 * @Date: 2021/7/20 11:08
 */
@Data
@ApiModel(description = "商品价格vo")
public class ProductPriceVo {

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;

  /**
   * 物料类型
   */
  @ApiModelProperty("物料类型")
  private String materialType;

  /**
   * 物料层级
   */
  @ApiModelProperty("物料层级")
  private String productLevelCode;

  /**
   * 成本价
   */
  @ApiModelProperty("成本价")
  private BigDecimal costPrice;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String specification;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String saleUnit;

  /**
   * 商品图片
   */
  @ApiModelProperty("商品图片")
  private String imgUrl;

  /**
   * 建议销售价
   */
  @ApiModelProperty("建议销售价")
  private BigDecimal suggestedPrice;

  /**
   * 底价
   */
  @ApiModelProperty("底价")
  private BigDecimal basePrice;
}
