/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.product.local.entity.Material;
import com.biz.crm.cps.business.product.local.entity.Product;
import com.biz.crm.cps.business.product.local.entity.ProductLevel;
import com.biz.crm.cps.business.product.local.entity.ProductMaterial;
import com.biz.crm.cps.business.product.local.repository.ProductRepository;
import com.biz.crm.cps.business.product.local.service.MaterialService;
import com.biz.crm.cps.business.product.local.service.ProductLevelService;
import com.biz.crm.cps.business.product.local.service.ProductMaterialService;
import com.biz.crm.cps.business.product.local.service.ProductService;
import com.biz.crm.cps.business.product.sdk.common.enums.ProductShelfStatusEnum;
import com.biz.crm.cps.business.product.sdk.common.enums.ProductTypeEnum;
import com.biz.crm.cps.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.cps.business.product.sdk.event.ProductEventListener;
import com.biz.crm.cps.business.product.sdk.vo.ProductVo;
import com.biz.crm.cps.external.mdm.sdk.dto.ProductMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.ProductLevelMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.ProductMaterialMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.ProductMdmVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ProductServiceImpl
implements ProductService {
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<ProductEventListener> productEventListenerList;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private ProductLevelService productLevelService;
    @Autowired
    private MaterialService materialService;
    @Autowired
    private ProductMaterialService productMaterialService;

    @Override
    @Transactional
    public Product create(Product product) {
        Product current = this.createForm(product);
        this.productRepository.save((Object)current);
        return current;
    }

    @Override
    public Product createForm(Product product) {
        Date now = new Date();
        String account = this.getLoginAccountName();
        product.setTenantCode(TenantUtils.getTenantCode());
        product.setCreateAccount(account);
        product.setCreateTime(now);
        product.setModifyAccount(account);
        product.setModifyTime(now);
        this.createValidation(product);
        if (StringUtils.isBlank((CharSequence)product.getDelFlag())) {
            product.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)product.getEnableStatus())) {
            product.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        if (StringUtils.isBlank((CharSequence)product.getProductCode())) {
            product.setProductCode((String)this.generateCodeService.generateCode("product", 1).get(0));
        }
        return product;
    }

    @Override
    @Transactional
    public Product update(Product product) {
        Product current = this.updateForm(product);
        return current;
    }

    @Override
    public Product updateForm(Product product) {
        this.updateValidation(product);
        String currentId = product.getId();
        String productCode = product.getProductCode();
        Product current = null;
        if (StringUtils.isNotBlank((CharSequence)currentId)) {
            current = (Product)((Object)this.productRepository.getById((Serializable)((Object)currentId)));
        } else if (StringUtils.isNotBlank((CharSequence)productCode)) {
            current = this.findByProductCode(productCode);
        }
        current = (Product)((Object)Validate.notNull((Object)((Object)current), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        ProductVo oldVo = null;
        if (!CollectionUtils.isEmpty(this.productEventListenerList)) {
            oldVo = (ProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, ProductVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        BeanUtils.copyProperties((Object)((Object)product), (Object)((Object)current), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode"});
        Date now = new Date();
        String account = this.getLoginAccountName();
        current.setModifyAccount(account);
        current.setModifyTime(now);
        this.productRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.productEventListenerList)) {
            ProductVo newVo = (ProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, ProductVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (ProductEventListener event : this.productEventListenerList) {
                event.onChange(oldVo, newVo);
            }
        }
        return current;
    }

    @Override
    public Product findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (Product)((Object)this.productRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public Product findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.productRepository.findDetailsById(id);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.productRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.productRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        if (!CollectionUtils.isEmpty(this.productEventListenerList)) {
            List<Product> terminals = this.productRepository.findByIds(ids);
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminals, Product.class, ProductVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (ProductEventListener event : this.productEventListenerList) {
                event.onDisable(voList);
            }
        }
    }

    @Override
    @Transactional
    public List<Product> createBatch(List<Product> products) {
        if (!CollectionUtils.isEmpty(products)) {
            for (Product product : products) {
                this.createForm(product);
            }
            this.productRepository.saveBatch(products);
            return products;
        }
        return Lists.newArrayList();
    }

    private List<Product> updateBatch(List<Product> products) {
        if (!CollectionUtils.isEmpty(products)) {
            for (Product product : products) {
                this.updateForm(product);
            }
            return products;
        }
        return Lists.newArrayList();
    }

    @Override
    public Product findByProductCode(String productCode) {
        if (StringUtils.isBlank((CharSequence)productCode)) {
            return null;
        }
        return this.productRepository.findByProductCode(productCode);
    }

    @Override
    public List<Product> findByProductLevelCode(String productLevelCode) {
        if (StringUtils.isBlank((CharSequence)productLevelCode)) {
            return null;
        }
        return this.productRepository.findByProductLevelCode(productLevelCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sync(ProductMdmPaginationDto productMdmPaginationDto) {
        Collection productMdmVos = null;
        Validate.notEmpty(productMdmVos, (String)"\u6ca1\u6709\u53d1\u73b0\u9700\u8981\u540c\u6b65\u7684\u5546\u54c1\u4fe1\u606f", (Object[])new Object[0]);
        List productLevelMdmVos = productMdmVos.stream().flatMap(item -> item.getProductLevels().stream()).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ProductLevelMdmVo>(Comparator.comparing(ProductLevelMdmVo::getId))), ArrayList::new));
        this.bulidProductLevel(productLevelMdmVos);
        List productMaterialMdmVos = productMdmVos.stream().flatMap(item -> item.getProductMaterials().stream()).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ProductMaterialMdmVo>(Comparator.comparing(ProductMaterialMdmVo::getId))), ArrayList::new));
        List materialMdmVos = productMaterialMdmVos.stream().map(ProductMaterialMdmVo::getMaterial).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MaterialMdmVo>(Comparator.comparing(MaterialMdmVo::getId))), ArrayList::new));
        this.bulidMaterial(materialMdmVos);
        this.bulidProduct((List<ProductMdmVo>)productMdmVos);
        this.bulidProductMaterial(productMaterialMdmVos);
    }

    @Override
    public Page<Product> findByConditions(Pageable pageable, ProductPaginationDto productPaginationDto) {
        ProductLevel productLevel;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (productPaginationDto == null) {
            productPaginationDto = new ProductPaginationDto();
        }
        productPaginationDto.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isNotBlank((CharSequence)productPaginationDto.getProductLevelCode()) && !Objects.isNull((Object)(productLevel = this.productLevelService.findByProductLevelCode(productPaginationDto.getProductLevelCode())))) {
            productPaginationDto.setProductLevelCode(null);
            productPaginationDto.setRuleCode(productLevel.getRuleCode());
        }
        return this.productRepository.findByConditions(pageable, productPaginationDto);
    }

    @Override
    @Transactional
    public void saveBatch(List<Product> target) {
        if (!CollectionUtils.isEmpty(target)) {
            List<String> productCodes = target.stream().map(Product::getProductCode).distinct().collect(Collectors.toList());
            List<Product> oldList = this.productRepository.findByProductCodes(productCodes);
            ArrayList addList = Lists.newArrayList();
            ArrayList needUpdateList = Lists.newArrayList();
            ArrayList delList = Lists.newArrayList();
            this.nebulaToolkitService.collectionDiscrepancy(target, oldList, Product::getProductCode, (Collection)delList, (Collection)needUpdateList, (Collection)addList);
            this.createBatch(addList);
            if (!CollectionUtils.isEmpty((Collection)needUpdateList)) {
                List needUpdateCodeList = needUpdateList.stream().map(Product::getProductCode).collect(Collectors.toList());
                List<Product> updateList = target.stream().filter(pitem -> needUpdateCodeList.contains(pitem.getProductCode())).collect(Collectors.toList());
                this.updateBatch(updateList);
            }
        }
    }

    private List<Product> bulidProduct(List<ProductMdmVo> productMdmVos) {
        List<Product> target = productMdmVos.stream().map(item -> {
            Product product = (Product)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(item, Product.class, HashSet.class, ArrayList.class, new String[0])));
            product.setExternalIdentifier(item.getId());
            product.setId(null);
            return product;
        }).collect(Collectors.toList());
        this.saveBatch(target);
        return target;
    }

    private List<ProductMaterial> bulidProductMaterial(List<ProductMaterialMdmVo> productMaterialMdmVos) {
        List<ProductMaterial> target = productMaterialMdmVos.stream().map(item -> {
            ProductMaterial productMaterial = (ProductMaterial)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(item, ProductMaterial.class, HashSet.class, ArrayList.class, new String[0])));
            productMaterial.setExternalIdentifier(item.getId());
            productMaterial.setId(null);
            return productMaterial;
        }).collect(Collectors.toList());
        this.productMaterialService.saveBatch(target);
        return target;
    }

    private List<Material> bulidMaterial(List<MaterialMdmVo> materialMdmVos) {
        List<Material> target = materialMdmVos.stream().map(item -> {
            Material material = new Material();
            BeanUtils.copyProperties((Object)item, (Object)((Object)material), (String[])new String[]{"costPrice"});
            material.setCostPrice(new BigDecimal(item.getCostPrice()));
            material.setExternalIdentifier(item.getId());
            material.setId(null);
            return material;
        }).collect(Collectors.toList());
        this.materialService.saveBatch(target);
        return target;
    }

    private List<ProductLevel> bulidProductLevel(List<ProductLevelMdmVo> productLevelMdmVos) {
        List<ProductLevel> target = productLevelMdmVos.stream().map(item -> {
            ProductLevel productLevel = (ProductLevel)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(item, ProductLevel.class, HashSet.class, ArrayList.class, new String[0])));
            productLevel.setExternalIdentifier(item.getId());
            productLevel.setId(null);
            return productLevel;
        }).collect(Collectors.toList());
        this.productLevelService.saveBatch(target);
        return target;
    }

    private void createValidation(Product product) {
        Validate.notNull((Object)((Object)product), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)product.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        product.setId(null);
        Validate.notBlank((CharSequence)product.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)product.getProductName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)product.getProductType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((product.getProductName().length() < 128 ? 1 : 0) != 0, (String)"\u5546\u54c1\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((product.getBarCode() == null || product.getBarCode().length() < 64 ? 1 : 0) != 0, (String)"\u6761\u5f62\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((product.getSaleCompany() == null || product.getSaleCompany().length() < 128 ? 1 : 0) != 0, (String)"\u9500\u552e\u516c\u53f8\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((product.getPrimaryPictureUrl() == null || product.getPrimaryPictureUrl().length() < 255 ? 1 : 0) != 0, (String)"\u4e3b\u56fe\u7247url\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((product.getSaleUnit() == null || product.getSaleUnit().length() < 64 ? 1 : 0) != 0, (String)"\u9500\u552e\u5355\u4f4d\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((product.getSpec() == null || product.getSpec().length() < 64 ? 1 : 0) != 0, (String)"\u89c4\u683c\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((product.getBaseUnit() == null || product.getBaseUnit().length() < 64 ? 1 : 0) != 0, (String)"\u57fa\u672c\u5355\u4f4d\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)ProductTypeEnum.getByKey((String)product.getProductType()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ProductShelfStatusEnum.getByKey((String)product.getIsShelf()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e0d\u5408\u6cd5\uff01", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)product.getProductCode())) {
            List list = ((LambdaQueryChainWrapper)this.productRepository.lambdaQuery().eq(Product::getProductCode, (Object)product.getProductCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)("\u7f16\u7801[" + product.getProductCode() + "]\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)product.getProductLevelCode())) {
            ProductLevel productLevel = this.productLevelService.findByProductLevelCode(product.getProductLevelCode());
            Validate.notNull((Object)((Object)productLevel), (String)("\u5546\u54c1\u5c42\u7ea7\u7f16\u7801[" + product.getProductLevelCode() + "]\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        }
    }

    private void updateValidation(Product product) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)product.getId()) || !StringUtils.isBlank((CharSequence)product.getProductCode()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e/\u7f16\u7801\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)product.getProductName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)product.getProductType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((product.getProductName().length() < 128 ? 1 : 0) != 0, (String)"\u5546\u54c1\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((product.getBarCode() == null || product.getBarCode().length() < 64 ? 1 : 0) != 0, (String)"\u6761\u5f62\u7801\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((product.getSaleCompany() == null || product.getSaleCompany().length() < 128 ? 1 : 0) != 0, (String)"\u9500\u552e\u516c\u53f8\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((product.getPrimaryPictureUrl() == null || product.getPrimaryPictureUrl().length() < 255 ? 1 : 0) != 0, (String)"\u4e3b\u56fe\u7247url\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((product.getSaleUnit() == null || product.getSaleUnit().length() < 64 ? 1 : 0) != 0, (String)"\u9500\u552e\u5355\u4f4d\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((product.getSpec() == null || product.getSpec().length() < 64 ? 1 : 0) != 0, (String)"\u89c4\u683c\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((product.getBaseUnit() == null || product.getBaseUnit().length() < 64 ? 1 : 0) != 0, (String)"\u57fa\u672c\u5355\u4f4d\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)ProductTypeEnum.getByKey((String)product.getProductType()), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ProductShelfStatusEnum.getByKey((String)product.getIsShelf()), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e0d\u5408\u6cd5\uff01", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)product.getProductLevelCode())) {
            ProductLevel productLevel = this.productLevelService.findByProductLevelCode(product.getProductLevelCode());
            Validate.notNull((Object)((Object)productLevel), (String)("\u5546\u54c1\u5c42\u7ea7\u7f16\u7801[" + product.getProductLevelCode() + "]\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        }
    }

    private String getLoginAccountName() {
        SecurityContext context = SecurityContextHolder.getContext();
        String account = "admin";
        if (context != null && context.getAuthentication() != null) {
            account = context.getAuthentication().getName();
        }
        return account;
    }
}

