package com.biz.crm.cps.business.product.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.product.local.service.MaterialGroupService;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialGroupMdmPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 物料组信息Controller相关http
 *
 * @author hecheng
 */
@Api(tags = "物料组信息")
@Slf4j
@RestController
@RequestMapping("/v1/product/materialGroup")
public class MaterialGroupController {

  @Autowired
  private MaterialGroupService materialGroupService;


  /**
   * 根据条件从mdm侧拉取数据，并存入cps侧系统从指定页 开始 拉去到最后一页
   */
  @ApiOperation(value = "根据条件从mdm侧拉取数据，并存入cps侧系统从指定页 开始 拉去到最后一页")
  @PostMapping(value = "/sync")
  public Result<Boolean> sync(@PageableDefault(50) Pageable pageable,
          @RequestBody @ApiParam(name = "materialGroupMdmPaginationDto", value = "物料组查询条件") MaterialGroupMdmPaginationDto materialGroupMdmPaginationDto) {
    try {
      this.materialGroupService.sync(pageable, materialGroupMdmPaginationDto);
      return Result.ok(true);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
