package com.biz.crm.cps.business.product.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.product.sdk.service.MaterialStandardUnitVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialStandardUnitVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 物料标箱转换信息
 *
 * @author hecheng
 */
@Api(tags = "物料标箱转换信息")
@Slf4j
@RestController
@RequestMapping("/v1/product/materialStandardUnit")
public class MaterialStandardUnitVoController {

  @Autowired
  private MaterialStandardUnitVoService materialStandardUnitVoService;


  /**
   * 查询所有的标箱转换规则。
   */
  @ApiOperation(value = "查询所有的标箱转换规则。")
  @RequestMapping(value = "/findAll", method = {RequestMethod.GET})
  public Result<List<MaterialStandardUnitVo>> findAll() {
    try {
      List<MaterialStandardUnitVo> vos = this.materialStandardUnitVoService.findAll();
      return Result.ok(vos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 标箱转换
   */
  @ApiOperation(value = "标箱转换")
  @GetMapping(value = "/findByBarCodes")
  public Result<MaterialStandardUnitVo> findByBarCodes(@RequestParam("barCodes") @ApiParam("barCodes") List<String> barCodes) {
    try {
      MaterialStandardUnitVo vo = this.materialStandardUnitVoService.findByBarCodes(barCodes);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
