package com.biz.crm.cps.business.product.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialDimensionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 物料信息
 *
 * @author hecheng
 */
@Api(tags = "物料信息")
@Slf4j
@RestController
@RequestMapping("/v1/product/material")
public class MaterialVoController {

  @Resource
  private MaterialVoService materialVoService;


  /**
   * 按照material实体中的（materialCode）进行查询物料维度。
   *
   * @param materialCode
   */
  @ApiOperation(value = "按照material实体中的（materialCode）进行查询商品维度。")
  @RequestMapping(value = "/findByMaterialCode", method = {RequestMethod.GET})
  public Result<MaterialDimensionVo> findByMaterialCode(
          @RequestParam("materialCode") @ApiParam("materialCode") String materialCode) {
    try {
      MaterialDimensionVo vo = this.materialVoService.findByMaterialCode(materialCode);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
