package com.biz.crm.cps.business.product.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.product.local.entity.Product;
import com.biz.crm.cps.business.product.local.service.ProductService;

import com.biz.crm.cps.business.product.sdk.dto.ProductPaginationDto;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 产品信息
 *
 * @author hecheng
 */
@Api(tags = "商品信息")
@Slf4j
@RestController
@RequestMapping("/v1/product/product")
public class ProductController {

  @Resource
  private ProductService productService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建product中的基本信息以外，还可以对product中属于OneToMany关联的明细信息一同进行创建注意：基于（product）模型的创建操作传入的productJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建product中的基本信息以外，还可以对product中属于OneToMany关联的明细信息一同进行创建注意：基于（product）模型的创建操作传入的productJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value = "")
  public Result<Product> create(
          @RequestBody @ApiParam(name = "product", value = "相关的创建过程，http接口。请注意该创建过程除了可以创建product中的基本信息以外，还可以对product中属于OneToMany关联的明细信息一同进行创建注意：基于（product）模型的创建操作传入的productJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") Product product) {
    try {
      Product current = this.productService.create(product);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（product）的修改操作传入的productJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（product）的修改操作传入的productJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value = "")
  public Result<Product> update(
          @RequestBody @ApiParam(name = "product", value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（product）的修改操作传入的productJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") Product product) {
    try {
      Product current = this.productService.update(product);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @GetMapping(value = "/{id}")
  public Result<Product> findById(
          @PathVariable("id") @ApiParam(name = "id", value = "主键") String id) {
    try {
      Product current = this.productService.findById(id);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 按照product实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param id 主键
   */
  @ApiOperation(value = "按照product实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value = "/findDetailsById", method = {RequestMethod.GET})
  public Result<Product> findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      Product result = this.productService.findDetailsById(id);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      this.productService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      this.productService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量录入商品信息
   */
  @ApiOperation(value = "批量录入商品信息")
  @PostMapping(value = "/createBatch")
  public Result<List<Product>> createBatch(
          @RequestBody @ApiParam(name = "product", value = "商品集合") List<Product> product) {
    try {
      List<Product> current = this.productService.createBatch(product);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;" +
          "可传的参数：productCode：商品编码，productName：商品名称, productLevelCode: 商品层级编码")
  @GetMapping("findByConditions")
  public Result<Page<Product>> findByConditions(@PageableDefault(50) Pageable pageable,
          @ApiParam(name = "productPaginationDto", value = "商品分页Dto") ProductPaginationDto productPaginationDto) {
    try {
      Page<Product> result = this.productService.findByConditions(pageable, productPaginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
