package com.biz.crm.cps.business.product.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.product.sdk.service.ProductVoService;
import com.biz.crm.cps.business.product.sdk.vo.ProductDimensionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商品信息
 *
 * @author hecheng
 */
@Api(tags = "商品信息")
@Slf4j
@RestController
@RequestMapping("/v1/product/productVo")
public class ProductVoController {

  @Resource
  private ProductVoService productVoService;


  /**
   * 按照product实体中的（productCode）进行查询商品维度。
   *
   * @param productCode 主键
   */
  @ApiOperation(value = "按照product实体中的（productCode）进行查询商品维度。")
  @RequestMapping(value = "/findByProductCode", method = {RequestMethod.GET})
  public Result<ProductDimensionVo> findByProductCode(
          @RequestParam("productCode") @ApiParam("productCode") String productCode) {
    try {
      ProductDimensionVo vo = this.productVoService.findByProductCode(productCode);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
