package com.biz.crm.cps.business.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.cps.business.product.sdk.common.enums.MaterialTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 物料信息
 *
 * @author hecheng
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "Material", description = "物料信息")
@TableName("material")
public class Material extends TenantFlagOpEntity {
  private static final long serialVersionUID = 3197515620118952423L;

  /**
   * 产品层级编码
   *
   * @Column(name = "product_level_code", nullable = false, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 产品层级编码 '")
   */
  @ApiModelProperty("产品层级编码")
  @TableField(value = "product_level_code")
  private String productLevelCode;

  /**
   * 物料编码
   *
   * @Column(name = "material_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 物料编码 '")
   */
  @ApiModelProperty("物料编码")
  @TableField(value = "material_code")
  private String materialCode;

  /**
   * 产品名称
   *
   * @Column(name = "material_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 产品名称 '")
   */
  @ApiModelProperty("产品名称")
  @TableField(value = "material_name")
  private String materialName;


  /**
   * ai编码
   *
   * @Column(name = "ai_code", nullable = true, length = 128, columnDefinition = "VARCHAR(128)
   * COMMENT ' ai编码 '")
   */
  @ApiModelProperty("ai编码")
  @TableField(value = "ai_code")
  private String aiCode;

  /**
   * 条形码
   *
   * @Column(name = "bar_code", nullable = true, length = 128, columnDefinition = "VARCHAR(128)
   * COMMENT ' 条形码 '")
   */
  @ApiModelProperty("条形码")
  @TableField(value = "bar_code")
  private String barCode;

  /**
   * 基本单位
   *
   * @Column(name = "base_unit", nullable = true, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 基本单位 '")
   */
  @ApiModelProperty("基本单位")
  @TableField(value = "base_unit")
  private String baseUnit;

  /**
   * 物料类型 {@link MaterialTypeEnum}
   *
   * @Column(name = "material_type", nullable = true, length = 32, columnDefinition = "VARCHAR(64)
   * COMMENT ' 物料类型 '")
   * <pre>
   * "big":"大"
   * "small", "小"
   * "bzsp": "标准商品"
   * "cx":"促销品"
   * "finished_product":"产成品"
   * "marketing_materials":"营销物料"
   * </pre>
   */
  @ApiModelProperty("物料类型")
  @TableField(value = "material_type")
  private String materialType;

  /**
   * 销售公司
   *
   * @Column(name = "sale_company", nullable = true, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 销售公司 '")
   */
  @ApiModelProperty("销售公司")
  @TableField(value = "sale_company")
  private String saleCompany;

  /**
   * 销售单位
   *
   * @Column(name = "sale_unit", nullable = true, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 销售单位 '")
   */
  @ApiModelProperty("销售单位")
  @TableField(value = "sale_unit")
  private String saleUnit;

  /**
   * 规格
   *
   * @Column(name = "specification", nullable = true, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 规格 '")
   */
  @ApiModelProperty("规格")
  @TableField(value = "specification")
  private String specification;

  /**
   * 单位换算系数
   *
   * @Column(name = "unit_conversion", nullable = true, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 单位换算系数 '")
   */
  @ApiModelProperty("单位换算系数")
  @TableField(value = "unit_conversion")
  private String unitConversion;

  /**
   * 成本价格
   *
   * @Column(name = "cost_price", nullable = true,  columnDefinition = "decimal(10, 2) COMMENT '
   * 成本价格 '")
   */
  @ApiModelProperty("成本价格")
  @TableField(value = "cost_price")
  private BigDecimal costPrice;

  /**
   * 毛重
   *
   * @Column(name = "gross_weight", nullable = true, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 毛重 '")
   */
  @ApiModelProperty("毛重")
  @TableField(value = "gross_weight")
  private String grossWeight;

  /**
   * 净重
   *
   * @Column(name = "net_weight", nullable = true, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 净重 '")
   */
  @ApiModelProperty("净重")
  @TableField(value = "net_weight")
  private String netWeight;

  /**
   * 容量
   *
   * @Column(name = "capacity", nullable = true, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 容量 '")
   */
  @ApiModelProperty("容量")
  @TableField(value = "capacity")
  private String capacity;


  /**
   * 外部 唯一标识
   *
   * @Column(name = "external_identifier", nullable = true, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 外部 唯一标识 '")
   */
  @ApiModelProperty("外部唯一标识")
  @TableField(value = "external_identifier")
  private String externalIdentifier;
  /**
   * 标准单位
   */
  @TableField(value = "standard_unit")
  private String standardUnit;
  /**
   * 盒码单位转算系数
   */
  @ApiModelProperty("盒码单位转算系数")
  @TableField(value = "box_unit_conversion")
  private BigDecimal boxUnitConversion;

  /**
   * 箱码单位转算系数
   */
  @ApiModelProperty("箱码单位转算系数")
  @TableField(value = "case_unit_conversion")
  private BigDecimal caseUnitConversion;
  /**
   * 产品层级
   *
   * @ManyToOne(fetch=FetchType.LAZY)
   * @JoinColumn(name = “product_level_id”,nullable=false)
   */
  @ApiModelProperty("产品层级")
  @TableField(exist = false)
  private ProductLevel productLevel;
}
