package com.biz.crm.cps.business.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @ClassName: MaterialGroup
 * @Author: hecheng
 * @Description: 物料组entity
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("material_group")
@Api(tags = "物料组实体")
public class MaterialGroup extends TenantFlagOpEntity {

  /**
   * 物料组编码
   * @Column(name = "material_group_code", nullable = false, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 物料组编码 '")
   */
  @TableField(value = "material_group_code")
  private String materialGroupCode;

  /**
   * 物料组名称
   * @Column(name = "material_group_name", nullable = false, length = 255, columnDefinition =
   * "VARCHAR(255) COMMENT ' 物料组名称 '")
   */
  @TableField(value = "material_group_name")
  private String materialGroupName;

  /**
   * 物料组描述
   * @Column(name = "description", nullable = false, length = 255, columnDefinition =
   * "VARCHAR(255) COMMENT ' 物料组描述 '")
   */
  @TableField(value = "description")
  private String description;

  /**
   * 物料数量
   * @Column(name = "material_num", nullable = false, length = 255, columnDefinition =
   * "decimal(10, 2) COMMENT ' 物料数量 '")
   */
  @TableField(value = "material_num")
  private BigDecimal materialNum;
  /**
   * 外部 唯一标识
   *
   * @Column(name = "external_identifier", nullable = true, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 外部 唯一标识 '")
   */
  @ApiModelProperty("外部唯一标识")
  @TableField(value = "external_identifier")
  private String externalIdentifier;
}
