package com.biz.crm.cps.business.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.Api;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @ClassName: MaterialGroupRel
 * @Author: hecheng
 * @Description: 物料组物料关系实体
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("material_group_rel")
@Api(tags = "物料组物料关系实体")
public class MaterialGroupRel extends UuidFlagOpEntity {

  /**
   * 物料组编码
   * @Column(name = "material_group_code", nullable = false, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 物料组编码 '")
   */
  @TableField(value = "material_group_code")
  private String materialGroupCode;

  /**
   * 物料编码
   * @Column(name = "material_code", nullable = false, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 物料编码 '")
   */
  @TableField(value = "material_code")
  private String materialCode;
}
