package com.biz.crm.cps.business.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @ClassName: MaterialMedia
 * @Author: hecheng
 * @Description: 物料照片
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("material_media")
@Api(tags = "物料图片实体")
public class MaterialMedia extends UuidFlagOpEntity {
  /**
   * 物料编码
   * @Column(name = "material_code", nullable = false, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 物料编码 '")
   */
  @TableField(value = "material_code")
  private String materialCode;
  /**
   * 物料id
   * @Column(name = "material_id", nullable = false, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 物料id '")
   */
  @TableField(value = "material_id")
  private String materialId;
  /**
   * 图片地址
   * @Column(name = "url_address", nullable = false, length = 255, columnDefinition =
   * "VARCHAR(255) COMMENT ' 图片地址 '")
   */
  @TableField(value = "url_address")
  private String urlAddress;
  /**
   * 排序位置
   * @Column(name = "range_num", nullable = false, length = 2, columnDefinition =
   * "int(2) COMMENT ' 排序位置 '")
   */
  @TableField(value = "range_num")
  private Integer rangeNum;


  /**
   * 图片类型(central 主图片 display 陈列图片 detail 详情图片)
   * @Column(name = "business_type", nullable = false, length = 10, columnDefinition =
   * "VARCHAR(10) COMMENT ' 图片类型(central 主图片 display 陈列图片 detail 详情图片) '")
   */
  @TableField(value = "business_type")
  private String businessType;

  /**
   * 文件名称
   * @Column(name = "file_name", nullable = false, length = 128, columnDefinition =
   * "VARCHAR(128) COMMENT ' 文件名称 '")
   */
  @TableField(value = "file_name")
  private String fileName;

  /**
   * 源文件名称
   * @Column(name = "original_file_name", nullable = false, length = 128, columnDefinition =
   * "VARCHAR(128) COMMENT ' 源文件名称 '")
   */
  @TableField(value = "original_file_name")
  private String originalFileName;

  /**
   * 地址
   * @Column(name = "relative_local", nullable = false, length = 255, columnDefinition =
   * "VARCHAR(255) COMMENT ' 地址 '")
   */
  @TableField(value = "relative_local")
  private String relativeLocal;

  /**
   * 数据状态（删除状态） 003 删除 009 正常
   */
  @ApiModelProperty("数据状态")
  private String delFlag;

  /**
   * 数据业务状态（启用状态） 003 禁用 009 启用
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;
  /**
   * 外部 唯一标识
   *
   * @Column(name = "external_identifier", nullable = true, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 外部 唯一标识 '")
   */
  @ApiModelProperty("外部唯一标识")
  @TableField(value = "external_identifier")
  private String externalIdentifier;
}
