package com.biz.crm.cps.business.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.cps.business.product.sdk.common.enums.ProductShelfStatusEnum;
import com.biz.crm.cps.business.product.sdk.common.enums.ProductTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品主表实体类
 *
 * @author hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "Product", description = "商品主表实体类")
@TableName("product")
public class Product extends TenantFlagOpEntity {
  private static final long serialVersionUID = -4245523819702535707L;

  /**
   * 商品编码
   *
   * @Column(name = "product_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 商品编码 '")
   */
  @ApiModelProperty("商品编码")
  @TableField(value = "product_code")
  private String productCode;

  /**
   * 商品名称
   *
   * @Column(name = "product_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128)
   * COMMENT ' 商品名称 '")
   */
  @ApiModelProperty("商品名称")
  @TableField(value = "product_name")
  private String productName;

  /**
   * 产品层级编码
   *
   * @Column(name = "product_level_code", nullable = false, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 产品层级编码 '")
   */
  @ApiModelProperty("产品层级编码")
  @TableField(value = "product_level_code")
  private String productLevelCode;

  /**
   * 商品类型(数据字典) {@link ProductTypeEnum}
   *
   * @Column(name = "product_type", nullable = false, length = 32, columnDefinition = "VARCHAR(32)
   * COMMENT ' 商品类型 '")
   *
   * <pre>"gift_package":"礼包商品"
   * "range":"范围商品"
   * "standard":"标准商品"</pre>
   */
  @ApiModelProperty("商品类型")
  @TableField(value = "product_type")
  private String productType;

  /**
   * 上下架状态(数据字典){@link ProductShelfStatusEnum} "Y","上架"；"N","下架"
   *
   * @Column(name = "is_shelf", nullable = false, length = 32, columnDefinition = "VARCHAR(32)
   * COMMENT ' 上下架状态 '")
   */
  @ApiModelProperty("上下架状态")
  @TableField(value = "is_shelf")
  private String isShelf;

  /**
   * 条形码
   *
   * @Column(name = "bar_code", nullable = true, length = 128, columnDefinition = "VARCHAR(128)
   * COMMENT ' 条形码 '")
   */
  @ApiModelProperty("条形码")
  @TableField(value = "bar_code")
  private String barCode;

  /**
   * 销售公司
   *
   * @Column(name = "sale_company", nullable = true, length = 128, columnDefinition = "VARCHAR(128)
   * COMMENT ' 销售公司 '")
   */
  @ApiModelProperty("销售公司")
  @TableField(value = "sale_company")
  private String saleCompany;

  /**
   * 主图片url
   *
   * @Column(name = "primary_picture_url", nullable = true, length = 255, columnDefinition =
   * "VARCHAR(255) COMMENT ' 主图片url '")
   */
  @ApiModelProperty("主图片url")
  @TableField(value = "primary_picture_url")
  private String primaryPictureUrl;

  /**
   * 销售单位
   *
   * @Column(name = "sale_unit", nullable = true, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 销售单位 '")
   */
  @ApiModelProperty("销售单位")
  @TableField(value = "sale_unit")
  private String saleUnit;

  /**
   * 规格
   *
   * @Column(name = "spec", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '
   * 规格 '")
   */
  @ApiModelProperty("规格")
  @TableField(value = "spec")
  private String spec;

  /**
   * 基本单位
   *
   * @Column(name = "base_unit", nullable = true, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 基本单位 '")
   */
  @ApiModelProperty("基本单位")
  @TableField(value = "base_unit")
  private String baseUnit;

  /**
   * 产品层级
   *
   * @ManyToOne(fetch=FetchType.LAZY)
   * @JoinColumn(name = “product_level_id”,nullable=false)
   */
  @ApiModelProperty("产品层级")
  @TableField(exist = false)
  private ProductLevel productLevel;

  /**
   * 外部 唯一标识
   *
   * @Column(name = "external_identifier", nullable = true, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 外部 唯一标识 '")
   */
  @ApiModelProperty("外部唯一标识")
  @TableField(value = "external_identifier")
  private String externalIdentifier;

  /**
   * 商品与物料关系
   *
   * @OneToMany(fetch = FetchType.LAZY,mappedBy = "product")
   */
  @ApiModelProperty("商品与物料关系")
  @TableField(exist = false)
  private Set<ProductMaterial> productMaterials;
}
