package com.biz.crm.cps.business.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.cps.business.product.sdk.common.enums.ProductLevelTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品层级 （品牌 大类 细类 系列）
 *
 * @author hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductLevel", description = "商品层级（品牌 大类 细类 系列）")
@TableName("product_level")
public class ProductLevel extends TenantFlagOpEntity {
  private static final long serialVersionUID = 6938420288293498628L;

  /**
   * 规则code查询用 这里使用上级product_level_code+分隔符生成
   *
   * @Column(name = "rule_code", nullable = false, length = 255, columnDefinition = "VARCHAR(255)
   * COMMENT ' 规则code查询用 '")
   */
  @ApiModelProperty("规则code查询用")
  @TableField(value = "rule_code")
  private String ruleCode;

  /**
   * 层级等级查询用
   *
   * @Column(name = "level_num", nullable = false, length = 10, columnDefinition = "VARCHAR(10)
   * COMMENT ' 层级等级查询用 '")
   */
  @ApiModelProperty("层级等级查询用")
  @TableField(value = "level_num")
  private Integer levelNum;
  /**
   * 上级编码
   *
   * @Column(name = "parent_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64)
   * COMMENT ' 上级编码 '")
   */
  @ApiModelProperty("上级编码")
  @TableField(value = "parent_code")
  private String parentCode;

  /**
   * 产品层级编码
   *
   * @Column(name = "product_level_code", nullable = false, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 产品层级编码 '")
   */
  @ApiModelProperty("产品层级编码")
  @TableField(value = "product_level_code")
  private String productLevelCode;

  /**
   * 产品层级名称
   *
   * @Column(name = "product_level_name", nullable = false, length = 128, columnDefinition =
   * "VARCHAR(128) COMMENT ' 产品层级名称 '")
   */
  @ApiModelProperty("产品层级名称")
  @TableField(value = "product_level_name")
  private String productLevelName;

  /**
   * 产品层级类型 {@link ProductLevelTypeEnum}
   *
   * @Column(name = "product_level_type", nullable = false, length = 32, columnDefinition =
   * "VARCHAR(32) COMMENT ' 产品层级类型 '")
   * <pre>
   *   "brand":"品牌"
   *   "series":"系列"
   *   "max":"大类"
   *   "min":"细类"
   * </pre>
   */
  @ApiModelProperty("产品层级类型")
  @TableField(value = "product_level_type")
  private String productLevelType;
  /**
   * 父节点
   *
   * @ManyToOne(fetch=FetchType.LAZY)
   * @JoinColumn(name = “parent_id”,nullable=false)
   * @ManyToOne
   */
  @ApiModelProperty("父节点")
  @TableField(exist = false)
  private ProductLevel parent;

  /**
   * 外部 唯一标识
   *
   * @Column(name = "external_identifier", nullable = true, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 外部 唯一标识 '")
   */
  @ApiModelProperty("外部唯一标识")
  @TableField(value = "external_identifier")
  private String externalIdentifier;
}
